package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{PageToken, AccountId}
import scala.jdk.CollectionConverters._
final case class ListPortfolioAccessResponse(
    accountIds: Option[Iterable[AccountId]] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse = {
    import ListPortfolioAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListPortfolioAccessResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListPortfolioAccessResponse
      .wrap(buildAwsValue())
}
object ListPortfolioAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListPortfolioAccessResponse =
      zio.aws.servicecatalog.model.ListPortfolioAccessResponse(
        accountIds.map(value => value),
        nextPageToken.map(value => value)
      )
    def accountIds: Option[List[AccountId]]
    def nextPageToken: Option[PageToken]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse
  ) extends zio.aws.servicecatalog.model.ListPortfolioAccessResponse.ReadOnly {
    override val accountIds: Option[List[AccountId]] = scala
      .Option(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.AccountId(item)
        }.toList
      )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse
  ): zio.aws.servicecatalog.model.ListPortfolioAccessResponse.ReadOnly =
    new Wrapper(impl)
}
