package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListBudgetsForResourceResponse(
    budgets: Option[Iterable[zio.aws.servicecatalog.model.BudgetDetail]] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse = {
    import ListBudgetsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse
      .builder()
      .optionallyWith(
        budgets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.budgets)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListBudgetsForResourceResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListBudgetsForResourceResponse
      .wrap(buildAwsValue())
}
object ListBudgetsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListBudgetsForResourceResponse =
      zio.aws.servicecatalog.model.ListBudgetsForResourceResponse(
        budgets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def budgets
        : Option[List[zio.aws.servicecatalog.model.BudgetDetail.ReadOnly]]
    def nextPageToken: Option[PageToken]
    def getBudgets: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.BudgetDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("budgets", budgets)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse
  ) extends zio.aws.servicecatalog.model.ListBudgetsForResourceResponse.ReadOnly {
    override val budgets
        : Option[List[zio.aws.servicecatalog.model.BudgetDetail.ReadOnly]] =
      scala
        .Option(impl.budgets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.BudgetDetail.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse
  ): zio.aws.servicecatalog.model.ListBudgetsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
