package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListAcceptedPortfolioSharesResponse(
    portfolioDetails: Option[
      Iterable[zio.aws.servicecatalog.model.PortfolioDetail]
    ] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse = {
    import ListAcceptedPortfolioSharesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse
      .builder()
      .optionallyWith(
        portfolioDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portfolioDetails)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse
      .wrap(buildAwsValue())
}
object ListAcceptedPortfolioSharesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse =
      zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse(
        portfolioDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def portfolioDetails
        : Option[List[zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly]]
    def nextPageToken: Option[PageToken]
    def getPortfolioDetails: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("portfolioDetails", portfolioDetails)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse
  ) extends zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse.ReadOnly {
    override val portfolioDetails
        : Option[List[zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly]] =
      scala
        .Option(impl.portfolioDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.PortfolioDetail.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse
  ): zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse.ReadOnly =
    new Wrapper(impl)
}
