package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class GetProvisionedProductOutputsResponse(
    outputs: Option[Iterable[zio.aws.servicecatalog.model.RecordOutput]] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse = {
    import GetProvisionedProductOutputsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse
      .builder()
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse.ReadOnly =
    zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse
      .wrap(buildAwsValue())
}
object GetProvisionedProductOutputsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse =
      zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse(
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def outputs
        : Option[List[zio.aws.servicecatalog.model.RecordOutput.ReadOnly]]
    def nextPageToken: Option[PageToken]
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.RecordOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse
  ) extends zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse.ReadOnly {
    override val outputs
        : Option[List[zio.aws.servicecatalog.model.RecordOutput.ReadOnly]] =
      scala
        .Option(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.RecordOutput.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse
  ): zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse.ReadOnly =
    new Wrapper(impl)
}
