package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{AcceptLanguage, Id}
import scala.jdk.CollectionConverters._
final case class DeleteServiceActionRequest(
    id: Id,
    acceptLanguage: Option[AcceptLanguage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionRequest = {
    import DeleteServiceActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionRequest
      .builder()
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DeleteServiceActionRequest.ReadOnly =
    zio.aws.servicecatalog.model.DeleteServiceActionRequest
      .wrap(buildAwsValue())
}
object DeleteServiceActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DeleteServiceActionRequest =
      zio.aws.servicecatalog.model
        .DeleteServiceActionRequest(id, acceptLanguage.map(value => value))
    def id: Id
    def acceptLanguage: Option[AcceptLanguage]
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionRequest
  ) extends zio.aws.servicecatalog.model.DeleteServiceActionRequest.ReadOnly {
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionRequest
  ): zio.aws.servicecatalog.model.DeleteServiceActionRequest.ReadOnly =
    new Wrapper(impl)
}
