package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.AcceptLanguage
import scala.jdk.CollectionConverters._
final case class BatchAssociateServiceActionWithProvisioningArtifactRequest(
    serviceActionAssociations: Iterable[
      zio.aws.servicecatalog.model.ServiceActionAssociation
    ],
    acceptLanguage: Option[AcceptLanguage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest = {
    import BatchAssociateServiceActionWithProvisioningArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest
      .builder()
      .serviceActionAssociations(serviceActionAssociations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest.ReadOnly =
    zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest
      .wrap(buildAwsValue())
}
object BatchAssociateServiceActionWithProvisioningArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest =
      zio.aws.servicecatalog.model
        .BatchAssociateServiceActionWithProvisioningArtifactRequest(
          serviceActionAssociations.map { item =>
            item.asEditable
          },
          acceptLanguage.map(value => value)
        )
    def serviceActionAssociations
        : List[zio.aws.servicecatalog.model.ServiceActionAssociation.ReadOnly]
    def acceptLanguage: Option[AcceptLanguage]
    def getServiceActionAssociations: ZIO[Any, Nothing, List[
      zio.aws.servicecatalog.model.ServiceActionAssociation.ReadOnly
    ]] = ZIO.succeed(serviceActionAssociations)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest
  ) extends zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest.ReadOnly {
    override val serviceActionAssociations
        : List[zio.aws.servicecatalog.model.ServiceActionAssociation.ReadOnly] =
      impl
        .serviceActionAssociations()
        .asScala
        .map { item =>
          zio.aws.servicecatalog.model.ServiceActionAssociation.wrap(item)
        }
        .toList
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest
  ): zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
