package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateTagOptionResponse(
    tagOptionDetail: Option[zio.aws.servicecatalog.model.TagOptionDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionResponse = {
    import UpdateTagOptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionResponse
      .builder()
      .optionallyWith(tagOptionDetail.map(value => value.buildAwsValue()))(
        _.tagOptionDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdateTagOptionResponse.ReadOnly =
    zio.aws.servicecatalog.model.UpdateTagOptionResponse.wrap(buildAwsValue())
}
object UpdateTagOptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdateTagOptionResponse =
      zio.aws.servicecatalog.model
        .UpdateTagOptionResponse(tagOptionDetail.map(value => value.asEditable))
    def tagOptionDetail
        : Option[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]
    def getTagOptionDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly
    ] = AwsError.unwrapOptionField("tagOptionDetail", tagOptionDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionResponse
  ) extends zio.aws.servicecatalog.model.UpdateTagOptionResponse.ReadOnly {
    override val tagOptionDetail
        : Option[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly] = scala
      .Option(impl.tagOptionDetail())
      .map(value => zio.aws.servicecatalog.model.TagOptionDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionResponse
  ): zio.aws.servicecatalog.model.UpdateTagOptionResponse.ReadOnly =
    new Wrapper(impl)
}
