package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateProvisionedProductResponse(
    recordDetail: Option[zio.aws.servicecatalog.model.RecordDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductResponse = {
    import UpdateProvisionedProductResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductResponse
      .builder()
      .optionallyWith(recordDetail.map(value => value.buildAwsValue()))(
        _.recordDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdateProvisionedProductResponse.ReadOnly =
    zio.aws.servicecatalog.model.UpdateProvisionedProductResponse
      .wrap(buildAwsValue())
}
object UpdateProvisionedProductResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.UpdateProvisionedProductResponse =
      zio.aws.servicecatalog.model.UpdateProvisionedProductResponse(
        recordDetail.map(value => value.asEditable)
      )
    def recordDetail: Option[zio.aws.servicecatalog.model.RecordDetail.ReadOnly]
    def getRecordDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.RecordDetail.ReadOnly
    ] = AwsError.unwrapOptionField("recordDetail", recordDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductResponse
  ) extends zio.aws.servicecatalog.model.UpdateProvisionedProductResponse.ReadOnly {
    override val recordDetail
        : Option[zio.aws.servicecatalog.model.RecordDetail.ReadOnly] = scala
      .Option(impl.recordDetail())
      .map(value => zio.aws.servicecatalog.model.RecordDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductResponse
  ): zio.aws.servicecatalog.model.UpdateProvisionedProductResponse.ReadOnly =
    new Wrapper(impl)
}
