package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateProductResponse(
    productViewDetail: Option[zio.aws.servicecatalog.model.ProductViewDetail] =
      None,
    tags: Option[Iterable[zio.aws.servicecatalog.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateProductResponse = {
    import UpdateProductResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateProductResponse
      .builder()
      .optionallyWith(productViewDetail.map(value => value.buildAwsValue()))(
        _.productViewDetail
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.UpdateProductResponse.ReadOnly =
    zio.aws.servicecatalog.model.UpdateProductResponse.wrap(buildAwsValue())
}
object UpdateProductResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateProductResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdateProductResponse =
      zio.aws.servicecatalog.model.UpdateProductResponse(
        productViewDetail.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def productViewDetail
        : Option[zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly]
    def tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def getProductViewDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly
    ] = AwsError.unwrapOptionField("productViewDetail", productViewDetail)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProductResponse
  ) extends zio.aws.servicecatalog.model.UpdateProductResponse.ReadOnly {
    override val productViewDetail
        : Option[zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly] =
      scala
        .Option(impl.productViewDetail())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewDetail.wrap(value)
        )
    override val tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProductResponse
  ): zio.aws.servicecatalog.model.UpdateProductResponse.ReadOnly = new Wrapper(
    impl
  )
}
