package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{Message, AccountId}
import scala.jdk.CollectionConverters._
final case class ShareError(
    accounts: Option[Iterable[AccountId]] = None,
    message: Option[Message] = None,
    error: Option[zio.aws.servicecatalog.model.primitives.Error] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ShareError = {
    import ShareError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ShareError
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        error.map(value =>
          zio.aws.servicecatalog.model.primitives.Error
            .unwrap(value): java.lang.String
        )
      )(_.error)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ShareError.ReadOnly =
    zio.aws.servicecatalog.model.ShareError.wrap(buildAwsValue())
}
object ShareError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ShareError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ShareError =
      zio.aws.servicecatalog.model.ShareError(
        accounts.map(value => value),
        message.map(value => value),
        error.map(value => value)
      )
    def accounts: Option[List[AccountId]]
    def message: Option[Message]
    def error: Option[zio.aws.servicecatalog.model.primitives.Error]
    def getAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getError
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.primitives.Error] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ShareError
  ) extends zio.aws.servicecatalog.model.ShareError.ReadOnly {
    override val accounts: Option[List[AccountId]] = scala
      .Option(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.AccountId(item)
        }.toList
      )
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.servicecatalog.model.primitives.Message(value))
    override val error: Option[zio.aws.servicecatalog.model.primitives.Error] =
      scala
        .Option(impl.error())
        .map(value => zio.aws.servicecatalog.model.primitives.Error(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ShareError
  ): zio.aws.servicecatalog.model.ShareError.ReadOnly = new Wrapper(impl)
}
