package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  SortField,
  SearchProvisionedProductsPageSize,
  PageToken,
  ProvisionedProductViewFilterValue
}
import scala.jdk.CollectionConverters._
final case class SearchProvisionedProductsRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    accessLevelFilter: Option[zio.aws.servicecatalog.model.AccessLevelFilter] =
      None,
    filters: Option[
      Map[zio.aws.servicecatalog.model.ProvisionedProductViewFilterBy, Iterable[
        ProvisionedProductViewFilterValue
      ]]
    ] = None,
    sortBy: Option[SortField] = None,
    sortOrder: Option[zio.aws.servicecatalog.model.SortOrder] = None,
    pageSize: Option[SearchProvisionedProductsPageSize] = None,
    pageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest = {
    import SearchProvisionedProductsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(accessLevelFilter.map(value => value.buildAwsValue()))(
        _.accessLevelFilter
      )
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                ProvisionedProductViewFilterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filtersWithStrings)
      .optionallyWith(
        sortBy.map(value => SortField.unwrap(value): java.lang.String)
      )(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        pageSize.map(value =>
          SearchProvisionedProductsPageSize.unwrap(value): Integer
        )
      )(_.pageSize)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.SearchProvisionedProductsRequest.ReadOnly =
    zio.aws.servicecatalog.model.SearchProvisionedProductsRequest
      .wrap(buildAwsValue())
}
object SearchProvisionedProductsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.SearchProvisionedProductsRequest =
      zio.aws.servicecatalog.model.SearchProvisionedProductsRequest(
        acceptLanguage.map(value => value),
        accessLevelFilter.map(value => value.asEditable),
        filters.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        pageSize.map(value => value),
        pageToken.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def accessLevelFilter
        : Option[zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly]
    def filters: Option[
      Map[zio.aws.servicecatalog.model.ProvisionedProductViewFilterBy, List[
        ProvisionedProductViewFilterValue
      ]]
    ]
    def sortBy: Option[SortField]
    def sortOrder: Option[zio.aws.servicecatalog.model.SortOrder]
    def pageSize: Option[SearchProvisionedProductsPageSize]
    def pageToken: Option[PageToken]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getAccessLevelFilter: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly
    ] = AwsError.unwrapOptionField("accessLevelFilter", accessLevelFilter)
    def getFilters: ZIO[Any, AwsError, Map[
      zio.aws.servicecatalog.model.ProvisionedProductViewFilterBy,
      List[ProvisionedProductViewFilterValue]
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getSortBy: ZIO[Any, AwsError, SortField] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getPageSize: ZIO[Any, AwsError, SearchProvisionedProductsPageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest
  ) extends zio.aws.servicecatalog.model.SearchProvisionedProductsRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val accessLevelFilter
        : Option[zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly] =
      scala
        .Option(impl.accessLevelFilter())
        .map(value =>
          zio.aws.servicecatalog.model.AccessLevelFilter.wrap(value)
        )
    override val filters: Option[
      Map[zio.aws.servicecatalog.model.ProvisionedProductViewFilterBy, List[
        ProvisionedProductViewFilterValue
      ]]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.servicecatalog.model.ProvisionedProductViewFilterBy
              .wrap(key) -> value.asScala.map { item =>
              zio.aws.servicecatalog.model.primitives
                .ProvisionedProductViewFilterValue(item)
            }.toList
          })
          .toMap
      )
    override val sortBy: Option[SortField] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.servicecatalog.model.primitives.SortField(value))
    override val sortOrder: Option[zio.aws.servicecatalog.model.SortOrder] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.servicecatalog.model.SortOrder.wrap(value))
    override val pageSize: Option[SearchProvisionedProductsPageSize] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .SearchProvisionedProductsPageSize(value)
      )
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest
  ): zio.aws.servicecatalog.model.SearchProvisionedProductsRequest.ReadOnly =
    new Wrapper(impl)
}
