package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageToken,
  PageSizeMax100,
  ProductViewFilterValue,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class SearchProductsRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    filters: Option[
      Map[zio.aws.servicecatalog.model.ProductViewFilterBy, Iterable[
        ProductViewFilterValue
      ]]
    ] = None,
    pageSize: Option[PageSizeMax100] = None,
    sortBy: Option[zio.aws.servicecatalog.model.ProductViewSortBy] = None,
    sortOrder: Option[zio.aws.servicecatalog.model.SortOrder] = None,
    pageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest = {
    import SearchProductsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                ProductViewFilterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filtersWithStrings)
      .optionallyWith(
        pageSize.map(value => PageSizeMax100.unwrap(value): Integer)
      )(_.pageSize)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.SearchProductsRequest.ReadOnly =
    zio.aws.servicecatalog.model.SearchProductsRequest.wrap(buildAwsValue())
}
object SearchProductsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.SearchProductsRequest =
      zio.aws.servicecatalog.model.SearchProductsRequest(
        acceptLanguage.map(value => value),
        filters.map(value => value),
        pageSize.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        pageToken.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def filters
        : Option[Map[zio.aws.servicecatalog.model.ProductViewFilterBy, List[
          ProductViewFilterValue
        ]]]
    def pageSize: Option[PageSizeMax100]
    def sortBy: Option[zio.aws.servicecatalog.model.ProductViewSortBy]
    def sortOrder: Option[zio.aws.servicecatalog.model.SortOrder]
    def pageToken: Option[PageToken]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getFilters: ZIO[Any, AwsError, Map[
      zio.aws.servicecatalog.model.ProductViewFilterBy,
      List[ProductViewFilterValue]
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getPageSize: ZIO[Any, AwsError, PageSizeMax100] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.ProductViewSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest
  ) extends zio.aws.servicecatalog.model.SearchProductsRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val filters
        : Option[Map[zio.aws.servicecatalog.model.ProductViewFilterBy, List[
          ProductViewFilterValue
        ]]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.servicecatalog.model.ProductViewFilterBy
              .wrap(key) -> value.asScala.map { item =>
              zio.aws.servicecatalog.model.primitives
                .ProductViewFilterValue(item)
            }.toList
          })
          .toMap
      )
    override val pageSize: Option[PageSizeMax100] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PageSizeMax100(value)
      )
    override val sortBy
        : Option[zio.aws.servicecatalog.model.ProductViewSortBy] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.servicecatalog.model.ProductViewSortBy.wrap(value))
    override val sortOrder: Option[zio.aws.servicecatalog.model.SortOrder] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.servicecatalog.model.SortOrder.wrap(value))
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest
  ): zio.aws.servicecatalog.model.SearchProductsRequest.ReadOnly = new Wrapper(
    impl
  )
}
