package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{RecordTagValue, RecordTagKey}
import scala.jdk.CollectionConverters._
final case class RecordTag(
    key: Option[RecordTagKey] = None,
    value: Option[RecordTagValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.RecordTag = {
    import RecordTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.RecordTag
      .builder()
      .optionallyWith(
        key.map(value => RecordTagKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => RecordTagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.RecordTag.ReadOnly =
    zio.aws.servicecatalog.model.RecordTag.wrap(buildAwsValue())
}
object RecordTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.RecordTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.RecordTag =
      zio.aws.servicecatalog.model
        .RecordTag(key.map(value => value), value.map(value => value))
    def key: Option[RecordTagKey]
    def value: Option[RecordTagValue]
    def getKey: ZIO[Any, AwsError, RecordTagKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, RecordTagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordTag
  ) extends zio.aws.servicecatalog.model.RecordTag.ReadOnly {
    override val key: Option[RecordTagKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.servicecatalog.model.primitives.RecordTagKey(value))
    override val value: Option[RecordTagValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.RecordTagValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordTag
  ): zio.aws.servicecatalog.model.RecordTag.ReadOnly = new Wrapper(impl)
}
