package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProvisioningArtifactView(
    productViewSummary: Option[
      zio.aws.servicecatalog.model.ProductViewSummary
    ] = None,
    provisioningArtifact: Option[
      zio.aws.servicecatalog.model.ProvisioningArtifact
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactView = {
    import ProvisioningArtifactView.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactView
      .builder()
      .optionallyWith(productViewSummary.map(value => value.buildAwsValue()))(
        _.productViewSummary
      )
      .optionallyWith(provisioningArtifact.map(value => value.buildAwsValue()))(
        _.provisioningArtifact
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisioningArtifactView.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningArtifactView.wrap(buildAwsValue())
}
object ProvisioningArtifactView {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactView
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningArtifactView =
      zio.aws.servicecatalog.model.ProvisioningArtifactView(
        productViewSummary.map(value => value.asEditable),
        provisioningArtifact.map(value => value.asEditable)
      )
    def productViewSummary
        : Option[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly]
    def provisioningArtifact
        : Option[zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly]
    def getProductViewSummary: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly
    ] = AwsError.unwrapOptionField("productViewSummary", productViewSummary)
    def getProvisioningArtifact: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly
    ] = AwsError.unwrapOptionField("provisioningArtifact", provisioningArtifact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactView
  ) extends zio.aws.servicecatalog.model.ProvisioningArtifactView.ReadOnly {
    override val productViewSummary
        : Option[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly] =
      scala
        .Option(impl.productViewSummary())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewSummary.wrap(value)
        )
    override val provisioningArtifact
        : Option[zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly] =
      scala
        .Option(impl.provisioningArtifact())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisioningArtifact.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactView
  ): zio.aws.servicecatalog.model.ProvisioningArtifactView.ReadOnly =
    new Wrapper(impl)
}
