package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{Region, AccountId}
import scala.jdk.CollectionConverters._
final case class ProvisioningArtifactPreferences(
    stackSetAccounts: Option[Iterable[AccountId]] = None,
    stackSetRegions: Option[Iterable[Region]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactPreferences = {
    import ProvisioningArtifactPreferences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactPreferences
      .builder()
      .optionallyWith(
        stackSetAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stackSetAccounts)
      .optionallyWith(
        stackSetRegions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stackSetRegions)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisioningArtifactPreferences.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningArtifactPreferences
      .wrap(buildAwsValue())
}
object ProvisioningArtifactPreferences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactPreferences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ProvisioningArtifactPreferences =
      zio.aws.servicecatalog.model.ProvisioningArtifactPreferences(
        stackSetAccounts.map(value => value),
        stackSetRegions.map(value => value)
      )
    def stackSetAccounts: Option[List[AccountId]]
    def stackSetRegions: Option[List[Region]]
    def getStackSetAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("stackSetAccounts", stackSetAccounts)
    def getStackSetRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("stackSetRegions", stackSetRegions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactPreferences
  ) extends zio.aws.servicecatalog.model.ProvisioningArtifactPreferences.ReadOnly {
    override val stackSetAccounts: Option[List[AccountId]] = scala
      .Option(impl.stackSetAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.AccountId(item)
        }.toList
      )
    override val stackSetRegions: Option[List[Region]] = scala
      .Option(impl.stackSetRegions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.Region(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactPreferences
  ): zio.aws.servicecatalog.model.ProvisioningArtifactPreferences.ReadOnly =
    new Wrapper(impl)
}
