package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.servicecatalog.model.primitives.{
  ProvisioningArtifactCreatedTime,
  ProvisioningArtifactDescription,
  ProvisioningArtifactName,
  Id
}
import scala.jdk.CollectionConverters._
final case class ProvisioningArtifact(
    id: Option[Id] = None,
    name: Option[ProvisioningArtifactName] = None,
    description: Option[ProvisioningArtifactDescription] = None,
    createdTime: Option[ProvisioningArtifactCreatedTime] = None,
    guidance: Option[
      zio.aws.servicecatalog.model.ProvisioningArtifactGuidance
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact = {
    import ProvisioningArtifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ProvisioningArtifactDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        createdTime.map(value =>
          ProvisioningArtifactCreatedTime.unwrap(value): Instant
        )
      )(_.createdTime)
      .optionallyWith(guidance.map(value => value.unwrap))(_.guidance)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningArtifact.wrap(buildAwsValue())
}
object ProvisioningArtifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningArtifact =
      zio.aws.servicecatalog.model.ProvisioningArtifact(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        createdTime.map(value => value),
        guidance.map(value => value)
      )
    def id: Option[Id]
    def name: Option[ProvisioningArtifactName]
    def description: Option[ProvisioningArtifactDescription]
    def createdTime: Option[ProvisioningArtifactCreatedTime]
    def guidance
        : Option[zio.aws.servicecatalog.model.ProvisioningArtifactGuidance]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ProvisioningArtifactName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ProvisioningArtifactDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTime: ZIO[Any, AwsError, ProvisioningArtifactCreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getGuidance: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactGuidance
    ] = AwsError.unwrapOptionField("guidance", guidance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact
  ) extends zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val name: Option[ProvisioningArtifactName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisioningArtifactName(value)
      )
    override val description: Option[ProvisioningArtifactDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisioningArtifactDescription(value)
      )
    override val createdTime: Option[ProvisioningArtifactCreatedTime] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisioningArtifactCreatedTime(value)
      )
    override val guidance
        : Option[zio.aws.servicecatalog.model.ProvisioningArtifactGuidance] =
      scala
        .Option(impl.guidance())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisioningArtifactGuidance.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact
  ): zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly = new Wrapper(
    impl
  )
}
