package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.servicecatalog.model.primitives.{
  ProvisionedProductPlanName,
  NotificationArn,
  ProvisionedProductName,
  UpdatedTime,
  CreatedTime,
  StatusMessage,
  Id
}
import scala.jdk.CollectionConverters._
final case class ProvisionedProductPlanDetails(
    createdTime: Option[CreatedTime] = None,
    pathId: Option[Id] = None,
    productId: Option[Id] = None,
    planName: Option[ProvisionedProductPlanName] = None,
    planId: Option[Id] = None,
    provisionProductId: Option[Id] = None,
    provisionProductName: Option[ProvisionedProductName] = None,
    planType: Option[zio.aws.servicecatalog.model.ProvisionedProductPlanType] =
      None,
    provisioningArtifactId: Option[Id] = None,
    status: Option[zio.aws.servicecatalog.model.ProvisionedProductPlanStatus] =
      None,
    updatedTime: Option[UpdatedTime] = None,
    notificationArns: Option[Iterable[NotificationArn]] = None,
    provisioningParameters: Option[
      Iterable[zio.aws.servicecatalog.model.UpdateProvisioningParameter]
    ] = None,
    tags: Option[Iterable[zio.aws.servicecatalog.model.Tag]] = None,
    statusMessage: Option[StatusMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails = {
    import ProvisionedProductPlanDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails
      .builder()
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(pathId.map(value => Id.unwrap(value): java.lang.String))(
        _.pathId
      )
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        planName.map(value =>
          ProvisionedProductPlanName.unwrap(value): java.lang.String
        )
      )(_.planName)
      .optionallyWith(planId.map(value => Id.unwrap(value): java.lang.String))(
        _.planId
      )
      .optionallyWith(
        provisionProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionProductId)
      .optionallyWith(
        provisionProductName.map(value =>
          ProvisionedProductName.unwrap(value): java.lang.String
        )
      )(_.provisionProductName)
      .optionallyWith(planType.map(value => value.unwrap))(_.planType)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        updatedTime.map(value => UpdatedTime.unwrap(value): Instant)
      )(_.updatedTime)
      .optionallyWith(
        notificationArns.map(value =>
          value.map { item =>
            NotificationArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationArns)
      .optionallyWith(
        provisioningParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningParameters)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisionedProductPlanDetails.ReadOnly =
    zio.aws.servicecatalog.model.ProvisionedProductPlanDetails
      .wrap(buildAwsValue())
}
object ProvisionedProductPlanDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisionedProductPlanDetails =
      zio.aws.servicecatalog.model.ProvisionedProductPlanDetails(
        createdTime.map(value => value),
        pathId.map(value => value),
        productId.map(value => value),
        planName.map(value => value),
        planId.map(value => value),
        provisionProductId.map(value => value),
        provisionProductName.map(value => value),
        planType.map(value => value),
        provisioningArtifactId.map(value => value),
        status.map(value => value),
        updatedTime.map(value => value),
        notificationArns.map(value => value),
        provisioningParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statusMessage.map(value => value)
      )
    def createdTime: Option[CreatedTime]
    def pathId: Option[Id]
    def productId: Option[Id]
    def planName: Option[ProvisionedProductPlanName]
    def planId: Option[Id]
    def provisionProductId: Option[Id]
    def provisionProductName: Option[ProvisionedProductName]
    def planType
        : Option[zio.aws.servicecatalog.model.ProvisionedProductPlanType]
    def provisioningArtifactId: Option[Id]
    def status
        : Option[zio.aws.servicecatalog.model.ProvisionedProductPlanStatus]
    def updatedTime: Option[UpdatedTime]
    def notificationArns: Option[List[NotificationArn]]
    def provisioningParameters: Option[
      List[zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly]
    ]
    def tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def statusMessage: Option[StatusMessage]
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getPathId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pathId", pathId)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getPlanName: ZIO[Any, AwsError, ProvisionedProductPlanName] =
      AwsError.unwrapOptionField("planName", planName)
    def getPlanId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("planId", planId)
    def getProvisionProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionProductId", provisionProductId)
    def getProvisionProductName: ZIO[Any, AwsError, ProvisionedProductName] =
      AwsError.unwrapOptionField("provisionProductName", provisionProductName)
    def getPlanType: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductPlanType
    ] = AwsError.unwrapOptionField("planType", planType)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductPlanStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getUpdatedTime: ZIO[Any, AwsError, UpdatedTime] =
      AwsError.unwrapOptionField("updatedTime", updatedTime)
    def getNotificationArns: ZIO[Any, AwsError, List[NotificationArn]] =
      AwsError.unwrapOptionField("notificationArns", notificationArns)
    def getProvisioningParameters: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningParameters",
      provisioningParameters
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails
  ) extends zio.aws.servicecatalog.model.ProvisionedProductPlanDetails.ReadOnly {
    override val createdTime: Option[CreatedTime] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreatedTime(value))
    override val pathId: Option[Id] = scala
      .Option(impl.pathId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Option[Id] = scala
      .Option(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val planName: Option[ProvisionedProductPlanName] = scala
      .Option(impl.planName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisionedProductPlanName(value)
      )
    override val planId: Option[Id] = scala
      .Option(impl.planId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionProductId: Option[Id] = scala
      .Option(impl.provisionProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionProductName: Option[ProvisionedProductName] = scala
      .Option(impl.provisionProductName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisionedProductName(value)
      )
    override val planType
        : Option[zio.aws.servicecatalog.model.ProvisionedProductPlanType] =
      scala
        .Option(impl.planType())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisionedProductPlanType.wrap(value)
        )
    override val provisioningArtifactId: Option[Id] = scala
      .Option(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val status
        : Option[zio.aws.servicecatalog.model.ProvisionedProductPlanStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisionedProductPlanStatus.wrap(value)
        )
    override val updatedTime: Option[UpdatedTime] = scala
      .Option(impl.updatedTime())
      .map(value => zio.aws.servicecatalog.model.primitives.UpdatedTime(value))
    override val notificationArns: Option[List[NotificationArn]] = scala
      .Option(impl.notificationArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.NotificationArn(item)
        }.toList
      )
    override val provisioningParameters: Option[
      List[zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly]
    ] = scala
      .Option(impl.provisioningParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.UpdateProvisioningParameter.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.StatusMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanDetails
  ): zio.aws.servicecatalog.model.ProvisionedProductPlanDetails.ReadOnly =
    new Wrapper(impl)
}
