package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProvisioningArtifactName,
  NotificationArn,
  ProvisionedProductName,
  ProductViewName,
  IdempotencyToken,
  PortfolioDisplayName,
  Id
}
import scala.jdk.CollectionConverters._
final case class ProvisionProductRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    productId: Option[Id] = None,
    productName: Option[ProductViewName] = None,
    provisioningArtifactId: Option[Id] = None,
    provisioningArtifactName: Option[ProvisioningArtifactName] = None,
    pathId: Option[Id] = None,
    pathName: Option[PortfolioDisplayName] = None,
    provisionedProductName: ProvisionedProductName,
    provisioningParameters: Option[
      Iterable[zio.aws.servicecatalog.model.ProvisioningParameter]
    ] = None,
    provisioningPreferences: Option[
      zio.aws.servicecatalog.model.ProvisioningPreferences
    ] = None,
    tags: Option[Iterable[zio.aws.servicecatalog.model.Tag]] = None,
    notificationArns: Option[Iterable[NotificationArn]] = None,
    provisionToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest = {
    import ProvisionProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        productName.map(value =>
          ProductViewName.unwrap(value): java.lang.String
        )
      )(_.productName)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(
        provisioningArtifactName.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.provisioningArtifactName)
      .optionallyWith(pathId.map(value => Id.unwrap(value): java.lang.String))(
        _.pathId
      )
      .optionallyWith(
        pathName.map(value =>
          PortfolioDisplayName.unwrap(value): java.lang.String
        )
      )(_.pathName)
      .provisionedProductName(
        ProvisionedProductName.unwrap(provisionedProductName): java.lang.String
      )
      .optionallyWith(
        provisioningParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningParameters)
      .optionallyWith(
        provisioningPreferences.map(value => value.buildAwsValue())
      )(_.provisioningPreferences)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        notificationArns.map(value =>
          value.map { item =>
            NotificationArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationArns)
      .provisionToken(IdempotencyToken.unwrap(provisionToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisionProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.ProvisionProductRequest.wrap(buildAwsValue())
}
object ProvisionProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisionProductRequest =
      zio.aws.servicecatalog.model.ProvisionProductRequest(
        acceptLanguage.map(value => value),
        productId.map(value => value),
        productName.map(value => value),
        provisioningArtifactId.map(value => value),
        provisioningArtifactName.map(value => value),
        pathId.map(value => value),
        pathName.map(value => value),
        provisionedProductName,
        provisioningParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisioningPreferences.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        notificationArns.map(value => value),
        provisionToken
      )
    def acceptLanguage: Option[AcceptLanguage]
    def productId: Option[Id]
    def productName: Option[ProductViewName]
    def provisioningArtifactId: Option[Id]
    def provisioningArtifactName: Option[ProvisioningArtifactName]
    def pathId: Option[Id]
    def pathName: Option[PortfolioDisplayName]
    def provisionedProductName: ProvisionedProductName
    def provisioningParameters: Option[
      List[zio.aws.servicecatalog.model.ProvisioningParameter.ReadOnly]
    ]
    def provisioningPreferences
        : Option[zio.aws.servicecatalog.model.ProvisioningPreferences.ReadOnly]
    def tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def notificationArns: Option[List[NotificationArn]]
    def provisionToken: IdempotencyToken
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProductName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("productName", productName)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getProvisioningArtifactName
        : ZIO[Any, AwsError, ProvisioningArtifactName] = AwsError
      .unwrapOptionField("provisioningArtifactName", provisioningArtifactName)
    def getPathId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pathId", pathId)
    def getPathName: ZIO[Any, AwsError, PortfolioDisplayName] =
      AwsError.unwrapOptionField("pathName", pathName)
    def getProvisionedProductName: ZIO[Any, Nothing, ProvisionedProductName] =
      ZIO.succeed(provisionedProductName)
    def getProvisioningParameters: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningParameters",
      provisioningParameters
    )
    def getProvisioningPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningPreferences",
      provisioningPreferences
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNotificationArns: ZIO[Any, AwsError, List[NotificationArn]] =
      AwsError.unwrapOptionField("notificationArns", notificationArns)
    def getProvisionToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(provisionToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest
  ) extends zio.aws.servicecatalog.model.ProvisionProductRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val productId: Option[Id] = scala
      .Option(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productName: Option[ProductViewName] = scala
      .Option(impl.productName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val provisioningArtifactId: Option[Id] = scala
      .Option(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactName: Option[ProvisioningArtifactName] =
      scala
        .Option(impl.provisioningArtifactName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val pathId: Option[Id] = scala
      .Option(impl.pathId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val pathName: Option[PortfolioDisplayName] = scala
      .Option(impl.pathName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PortfolioDisplayName(value)
      )
    override val provisionedProductName: ProvisionedProductName =
      zio.aws.servicecatalog.model.primitives
        .ProvisionedProductName(impl.provisionedProductName())
    override val provisioningParameters: Option[
      List[zio.aws.servicecatalog.model.ProvisioningParameter.ReadOnly]
    ] = scala
      .Option(impl.provisioningParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningParameter.wrap(item)
        }.toList
      )
    override val provisioningPreferences: Option[
      zio.aws.servicecatalog.model.ProvisioningPreferences.ReadOnly
    ] = scala
      .Option(impl.provisioningPreferences())
      .map(value =>
        zio.aws.servicecatalog.model.ProvisioningPreferences.wrap(value)
      )
    override val tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val notificationArns: Option[List[NotificationArn]] = scala
      .Option(impl.notificationArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.NotificationArn(item)
        }.toList
      )
    override val provisionToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.provisionToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest
  ): zio.aws.servicecatalog.model.ProvisionProductRequest.ReadOnly =
    new Wrapper(impl)
}
