package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListTagOptionsResponse(
    tagOptionDetails: Option[
      Iterable[zio.aws.servicecatalog.model.TagOptionDetail]
    ] = None,
    pageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse = {
    import ListTagOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse
      .builder()
      .optionallyWith(
        tagOptionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagOptionDetails)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ListTagOptionsResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListTagOptionsResponse.wrap(buildAwsValue())
}
object ListTagOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListTagOptionsResponse =
      zio.aws.servicecatalog.model.ListTagOptionsResponse(
        tagOptionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pageToken.map(value => value)
      )
    def tagOptionDetails
        : Option[List[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]]
    def pageToken: Option[PageToken]
    def getTagOptionDetails: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("tagOptionDetails", tagOptionDetails)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse
  ) extends zio.aws.servicecatalog.model.ListTagOptionsResponse.ReadOnly {
    override val tagOptionDetails
        : Option[List[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]] =
      scala
        .Option(impl.tagOptionDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.TagOptionDetail.wrap(item)
          }.toList
        )
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse
  ): zio.aws.servicecatalog.model.ListTagOptionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
