package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListStackInstancesForProvisionedProductResponse(
    stackInstances: Option[
      Iterable[zio.aws.servicecatalog.model.StackInstance]
    ] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductResponse = {
    import ListStackInstancesForProvisionedProductResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductResponse
      .builder()
      .optionallyWith(
        stackInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stackInstances)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductResponse
      .wrap(buildAwsValue())
}
object ListStackInstancesForProvisionedProductResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductResponse =
      zio.aws.servicecatalog.model
        .ListStackInstancesForProvisionedProductResponse(
          stackInstances.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextPageToken.map(value => value)
        )
    def stackInstances
        : Option[List[zio.aws.servicecatalog.model.StackInstance.ReadOnly]]
    def nextPageToken: Option[PageToken]
    def getStackInstances: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.StackInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("stackInstances", stackInstances)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductResponse
  ) extends zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductResponse.ReadOnly {
    override val stackInstances
        : Option[List[zio.aws.servicecatalog.model.StackInstance.ReadOnly]] =
      scala
        .Option(impl.stackInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.StackInstance.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductResponse
  ): zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductResponse.ReadOnly =
    new Wrapper(impl)
}
