package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  PageToken,
  PageSize,
  Id
}
import scala.jdk.CollectionConverters._
final case class ListServiceActionsForProvisioningArtifactRequest(
    productId: Id,
    provisioningArtifactId: Id,
    pageSize: Option[PageSize] = None,
    pageToken: Option[PageToken] = None,
    acceptLanguage: Option[AcceptLanguage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest = {
    import ListServiceActionsForProvisioningArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest
      .builder()
      .productId(Id.unwrap(productId): java.lang.String)
      .provisioningArtifactId(
        Id.unwrap(provisioningArtifactId): java.lang.String
      )
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest
      .wrap(buildAwsValue())
}
object ListServiceActionsForProvisioningArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest =
      zio.aws.servicecatalog.model
        .ListServiceActionsForProvisioningArtifactRequest(
          productId,
          provisioningArtifactId,
          pageSize.map(value => value),
          pageToken.map(value => value),
          acceptLanguage.map(value => value)
        )
    def productId: Id
    def provisioningArtifactId: Id
    def pageSize: Option[PageSize]
    def pageToken: Option[PageToken]
    def acceptLanguage: Option[AcceptLanguage]
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getProvisioningArtifactId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisioningArtifactId)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest
  ) extends zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest.ReadOnly {
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val provisioningArtifactId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisioningArtifactId())
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest
  ): zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
