package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageToken,
  PageSize,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class ListRecordHistoryRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    accessLevelFilter: Option[zio.aws.servicecatalog.model.AccessLevelFilter] =
      None,
    searchFilter: Option[
      zio.aws.servicecatalog.model.ListRecordHistorySearchFilter
    ] = None,
    pageSize: Option[PageSize] = None,
    pageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest = {
    import ListRecordHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(accessLevelFilter.map(value => value.buildAwsValue()))(
        _.accessLevelFilter
      )
      .optionallyWith(searchFilter.map(value => value.buildAwsValue()))(
        _.searchFilter
      )
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListRecordHistoryRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListRecordHistoryRequest.wrap(buildAwsValue())
}
object ListRecordHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListRecordHistoryRequest =
      zio.aws.servicecatalog.model.ListRecordHistoryRequest(
        acceptLanguage.map(value => value),
        accessLevelFilter.map(value => value.asEditable),
        searchFilter.map(value => value.asEditable),
        pageSize.map(value => value),
        pageToken.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def accessLevelFilter
        : Option[zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly]
    def searchFilter: Option[
      zio.aws.servicecatalog.model.ListRecordHistorySearchFilter.ReadOnly
    ]
    def pageSize: Option[PageSize]
    def pageToken: Option[PageToken]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getAccessLevelFilter: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly
    ] = AwsError.unwrapOptionField("accessLevelFilter", accessLevelFilter)
    def getSearchFilter: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ListRecordHistorySearchFilter.ReadOnly
    ] = AwsError.unwrapOptionField("searchFilter", searchFilter)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest
  ) extends zio.aws.servicecatalog.model.ListRecordHistoryRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val accessLevelFilter
        : Option[zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly] =
      scala
        .Option(impl.accessLevelFilter())
        .map(value =>
          zio.aws.servicecatalog.model.AccessLevelFilter.wrap(value)
        )
    override val searchFilter: Option[
      zio.aws.servicecatalog.model.ListRecordHistorySearchFilter.ReadOnly
    ] = scala
      .Option(impl.searchFilter())
      .map(value =>
        zio.aws.servicecatalog.model.ListRecordHistorySearchFilter.wrap(value)
      )
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest
  ): zio.aws.servicecatalog.model.ListRecordHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
