package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageToken,
  PageSize,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class ListProvisionedProductPlansRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    provisionProductId: Option[Id] = None,
    pageSize: Option[PageSize] = None,
    pageToken: Option[PageToken] = None,
    accessLevelFilter: Option[zio.aws.servicecatalog.model.AccessLevelFilter] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest = {
    import ListProvisionedProductPlansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        provisionProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionProductId)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(accessLevelFilter.map(value => value.buildAwsValue()))(
        _.accessLevelFilter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest
      .wrap(buildAwsValue())
}
object ListProvisionedProductPlansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest =
      zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest(
        acceptLanguage.map(value => value),
        provisionProductId.map(value => value),
        pageSize.map(value => value),
        pageToken.map(value => value),
        accessLevelFilter.map(value => value.asEditable)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def provisionProductId: Option[Id]
    def pageSize: Option[PageSize]
    def pageToken: Option[PageToken]
    def accessLevelFilter
        : Option[zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProvisionProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionProductId", provisionProductId)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getAccessLevelFilter: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly
    ] = AwsError.unwrapOptionField("accessLevelFilter", accessLevelFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest
  ) extends zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val provisionProductId: Option[Id] = scala
      .Option(impl.provisionProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val accessLevelFilter
        : Option[zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly] =
      scala
        .Option(impl.accessLevelFilter())
        .map(value =>
          zio.aws.servicecatalog.model.AccessLevelFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest
  ): zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest.ReadOnly =
    new Wrapper(impl)
}
