package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageSizeMax100,
  PageToken,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class ListPortfoliosForProductRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    productId: Id,
    pageToken: Option[PageToken] = None,
    pageSize: Option[PageSizeMax100] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest = {
    import ListPortfoliosForProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .productId(Id.unwrap(productId): java.lang.String)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(
        pageSize.map(value => PageSizeMax100.unwrap(value): Integer)
      )(_.pageSize)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListPortfoliosForProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListPortfoliosForProductRequest
      .wrap(buildAwsValue())
}
object ListPortfoliosForProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListPortfoliosForProductRequest =
      zio.aws.servicecatalog.model.ListPortfoliosForProductRequest(
        acceptLanguage.map(value => value),
        productId,
        pageToken.map(value => value),
        pageSize.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def productId: Id
    def pageToken: Option[PageToken]
    def pageSize: Option[PageSizeMax100]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getPageSize: ZIO[Any, AwsError, PageSizeMax100] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest
  ) extends zio.aws.servicecatalog.model.ListPortfoliosForProductRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val pageSize: Option[PageSizeMax100] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PageSizeMax100(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest
  ): zio.aws.servicecatalog.model.ListPortfoliosForProductRequest.ReadOnly =
    new Wrapper(impl)
}
