package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageSize,
  PageToken,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class ListOrganizationPortfolioAccessRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    portfolioId: Id,
    organizationNodeType: zio.aws.servicecatalog.model.OrganizationNodeType,
    pageToken: Option[PageToken] = None,
    pageSize: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest = {
    import ListOrganizationPortfolioAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .organizationNodeType(organizationNodeType.unwrap)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessRequest
      .wrap(buildAwsValue())
}
object ListOrganizationPortfolioAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessRequest =
      zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessRequest(
        acceptLanguage.map(value => value),
        portfolioId,
        organizationNodeType,
        pageToken.map(value => value),
        pageSize.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def portfolioId: Id
    def organizationNodeType: zio.aws.servicecatalog.model.OrganizationNodeType
    def pageToken: Option[PageToken]
    def pageSize: Option[PageSize]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getOrganizationNodeType
        : ZIO[Any, Nothing, zio.aws.servicecatalog.model.OrganizationNodeType] =
      ZIO.succeed(organizationNodeType)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest
  ) extends zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val organizationNodeType
        : zio.aws.servicecatalog.model.OrganizationNodeType =
      zio.aws.servicecatalog.model.OrganizationNodeType
        .wrap(impl.organizationNodeType())
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest
  ): zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessRequest.ReadOnly =
    new Wrapper(impl)
}
