package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListLaunchPathsResponse(
    launchPathSummaries: Option[
      Iterable[zio.aws.servicecatalog.model.LaunchPathSummary]
    ] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse = {
    import ListLaunchPathsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse
      .builder()
      .optionallyWith(
        launchPathSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchPathSummaries)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListLaunchPathsResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListLaunchPathsResponse.wrap(buildAwsValue())
}
object ListLaunchPathsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListLaunchPathsResponse =
      zio.aws.servicecatalog.model.ListLaunchPathsResponse(
        launchPathSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def launchPathSummaries
        : Option[List[zio.aws.servicecatalog.model.LaunchPathSummary.ReadOnly]]
    def nextPageToken: Option[PageToken]
    def getLaunchPathSummaries: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.LaunchPathSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("launchPathSummaries", launchPathSummaries)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse
  ) extends zio.aws.servicecatalog.model.ListLaunchPathsResponse.ReadOnly {
    override val launchPathSummaries: Option[
      List[zio.aws.servicecatalog.model.LaunchPathSummary.ReadOnly]
    ] = scala
      .Option(impl.launchPathSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.LaunchPathSummary.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse
  ): zio.aws.servicecatalog.model.ListLaunchPathsResponse.ReadOnly =
    new Wrapper(impl)
}
