package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageSize,
  PageToken,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class DescribeRecordRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    id: Id,
    pageToken: Option[PageToken] = None,
    pageSize: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest = {
    import DescribeRecordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.DescribeRecordRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeRecordRequest.wrap(buildAwsValue())
}
object DescribeRecordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribeRecordRequest =
      zio.aws.servicecatalog.model.DescribeRecordRequest(
        acceptLanguage.map(value => value),
        id,
        pageToken.map(value => value),
        pageSize.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def id: Id
    def pageToken: Option[PageToken]
    def pageSize: Option[PageSize]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest
  ) extends zio.aws.servicecatalog.model.DescribeRecordRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest
  ): zio.aws.servicecatalog.model.DescribeRecordRequest.ReadOnly = new Wrapper(
    impl
  )
}
