package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProvisioningArtifactName,
  ProductViewName,
  PortfolioDisplayName,
  Id
}
import scala.jdk.CollectionConverters._
final case class DescribeProvisioningParametersRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    productId: Option[Id] = None,
    productName: Option[ProductViewName] = None,
    provisioningArtifactId: Option[Id] = None,
    provisioningArtifactName: Option[ProvisioningArtifactName] = None,
    pathId: Option[Id] = None,
    pathName: Option[PortfolioDisplayName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest = {
    import DescribeProvisioningParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        productName.map(value =>
          ProductViewName.unwrap(value): java.lang.String
        )
      )(_.productName)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(
        provisioningArtifactName.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.provisioningArtifactName)
      .optionallyWith(pathId.map(value => Id.unwrap(value): java.lang.String))(
        _.pathId
      )
      .optionallyWith(
        pathName.map(value =>
          PortfolioDisplayName.unwrap(value): java.lang.String
        )
      )(_.pathName)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest
      .wrap(buildAwsValue())
}
object DescribeProvisioningParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest =
      zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest(
        acceptLanguage.map(value => value),
        productId.map(value => value),
        productName.map(value => value),
        provisioningArtifactId.map(value => value),
        provisioningArtifactName.map(value => value),
        pathId.map(value => value),
        pathName.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def productId: Option[Id]
    def productName: Option[ProductViewName]
    def provisioningArtifactId: Option[Id]
    def provisioningArtifactName: Option[ProvisioningArtifactName]
    def pathId: Option[Id]
    def pathName: Option[PortfolioDisplayName]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProductName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("productName", productName)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getProvisioningArtifactName
        : ZIO[Any, AwsError, ProvisioningArtifactName] = AwsError
      .unwrapOptionField("provisioningArtifactName", provisioningArtifactName)
    def getPathId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pathId", pathId)
    def getPathName: ZIO[Any, AwsError, PortfolioDisplayName] =
      AwsError.unwrapOptionField("pathName", pathName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest
  ) extends zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val productId: Option[Id] = scala
      .Option(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productName: Option[ProductViewName] = scala
      .Option(impl.productName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val provisioningArtifactId: Option[Id] = scala
      .Option(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactName: Option[ProvisioningArtifactName] =
      scala
        .Option(impl.provisioningArtifactName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val pathId: Option[Id] = scala
      .Option(impl.pathId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val pathName: Option[PortfolioDisplayName] = scala
      .Option(impl.pathName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PortfolioDisplayName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest
  ): zio.aws.servicecatalog.model.DescribeProvisioningParametersRequest.ReadOnly =
    new Wrapper(impl)
}
