package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeProductViewResponse(
    productViewSummary: Option[
      zio.aws.servicecatalog.model.ProductViewSummary
    ] = None,
    provisioningArtifacts: Option[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifact]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse = {
    import DescribeProductViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse
      .builder()
      .optionallyWith(productViewSummary.map(value => value.buildAwsValue()))(
        _.productViewSummary
      )
      .optionallyWith(
        provisioningArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifacts)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProductViewResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProductViewResponse
      .wrap(buildAwsValue())
}
object DescribeProductViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribeProductViewResponse =
      zio.aws.servicecatalog.model.DescribeProductViewResponse(
        productViewSummary.map(value => value.asEditable),
        provisioningArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def productViewSummary
        : Option[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly]
    def provisioningArtifacts: Option[
      List[zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly]
    ]
    def getProductViewSummary: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly
    ] = AwsError.unwrapOptionField("productViewSummary", productViewSummary)
    def getProvisioningArtifacts: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly
    ]] =
      AwsError.unwrapOptionField("provisioningArtifacts", provisioningArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse
  ) extends zio.aws.servicecatalog.model.DescribeProductViewResponse.ReadOnly {
    override val productViewSummary
        : Option[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly] =
      scala
        .Option(impl.productViewSummary())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewSummary.wrap(value)
        )
    override val provisioningArtifacts: Option[
      List[zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly]
    ] = scala
      .Option(impl.provisioningArtifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifact.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse
  ): zio.aws.servicecatalog.model.DescribeProductViewResponse.ReadOnly =
    new Wrapper(impl)
}
