package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  IgnoreErrors,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class DeleteProvisionedProductPlanRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    planId: Id,
    ignoreErrors: Option[IgnoreErrors] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanRequest = {
    import DeleteProvisionedProductPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .planId(Id.unwrap(planId): java.lang.String)
      .optionallyWith(
        ignoreErrors.map(value => IgnoreErrors.unwrap(value): java.lang.Boolean)
      )(_.ignoreErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DeleteProvisionedProductPlanRequest.ReadOnly =
    zio.aws.servicecatalog.model.DeleteProvisionedProductPlanRequest
      .wrap(buildAwsValue())
}
object DeleteProvisionedProductPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DeleteProvisionedProductPlanRequest =
      zio.aws.servicecatalog.model.DeleteProvisionedProductPlanRequest(
        acceptLanguage.map(value => value),
        planId,
        ignoreErrors.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def planId: Id
    def ignoreErrors: Option[IgnoreErrors]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPlanId: ZIO[Any, Nothing, Id] = ZIO.succeed(planId)
    def getIgnoreErrors: ZIO[Any, AwsError, IgnoreErrors] =
      AwsError.unwrapOptionField("ignoreErrors", ignoreErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanRequest
  ) extends zio.aws.servicecatalog.model.DeleteProvisionedProductPlanRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val planId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.planId())
    override val ignoreErrors: Option[IgnoreErrors] = scala
      .Option(impl.ignoreErrors())
      .map(value => zio.aws.servicecatalog.model.primitives.IgnoreErrors(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanRequest
  ): zio.aws.servicecatalog.model.DeleteProvisionedProductPlanRequest.ReadOnly =
    new Wrapper(impl)
}
