package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  ProvisionedProductName,
  Id,
  ProvisionedProductPlanName
}
import scala.jdk.CollectionConverters._
final case class CreateProvisionedProductPlanResponse(
    planName: Option[ProvisionedProductPlanName] = None,
    planId: Option[Id] = None,
    provisionProductId: Option[Id] = None,
    provisionedProductName: Option[ProvisionedProductName] = None,
    provisioningArtifactId: Option[Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanResponse = {
    import CreateProvisionedProductPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanResponse
      .builder()
      .optionallyWith(
        planName.map(value =>
          ProvisionedProductPlanName.unwrap(value): java.lang.String
        )
      )(_.planName)
      .optionallyWith(planId.map(value => Id.unwrap(value): java.lang.String))(
        _.planId
      )
      .optionallyWith(
        provisionProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionProductId)
      .optionallyWith(
        provisionedProductName.map(value =>
          ProvisionedProductName.unwrap(value): java.lang.String
        )
      )(_.provisionedProductName)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse.ReadOnly =
    zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse
      .wrap(buildAwsValue())
}
object CreateProvisionedProductPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse =
      zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse(
        planName.map(value => value),
        planId.map(value => value),
        provisionProductId.map(value => value),
        provisionedProductName.map(value => value),
        provisioningArtifactId.map(value => value)
      )
    def planName: Option[ProvisionedProductPlanName]
    def planId: Option[Id]
    def provisionProductId: Option[Id]
    def provisionedProductName: Option[ProvisionedProductName]
    def provisioningArtifactId: Option[Id]
    def getPlanName: ZIO[Any, AwsError, ProvisionedProductPlanName] =
      AwsError.unwrapOptionField("planName", planName)
    def getPlanId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("planId", planId)
    def getProvisionProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionProductId", provisionProductId)
    def getProvisionedProductName: ZIO[Any, AwsError, ProvisionedProductName] =
      AwsError.unwrapOptionField(
        "provisionedProductName",
        provisionedProductName
      )
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanResponse
  ) extends zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse.ReadOnly {
    override val planName: Option[ProvisionedProductPlanName] = scala
      .Option(impl.planName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisionedProductPlanName(value)
      )
    override val planId: Option[Id] = scala
      .Option(impl.planId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionProductId: Option[Id] = scala
      .Option(impl.provisionProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionedProductName: Option[ProvisionedProductName] = scala
      .Option(impl.provisionedProductName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisionedProductName(value)
      )
    override val provisioningArtifactId: Option[Id] = scala
      .Option(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanResponse
  ): zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse.ReadOnly =
    new Wrapper(impl)
}
