package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.AcceptLanguage
import scala.jdk.CollectionConverters._
final case class BatchDisassociateServiceActionFromProvisioningArtifactRequest(
    serviceActionAssociations: Iterable[
      zio.aws.servicecatalog.model.ServiceActionAssociation
    ],
    acceptLanguage: Option[AcceptLanguage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest = {
    import BatchDisassociateServiceActionFromProvisioningArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest
      .builder()
      .serviceActionAssociations(serviceActionAssociations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest.ReadOnly =
    zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest
      .wrap(buildAwsValue())
}
object BatchDisassociateServiceActionFromProvisioningArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest =
      zio.aws.servicecatalog.model
        .BatchDisassociateServiceActionFromProvisioningArtifactRequest(
          serviceActionAssociations.map { item =>
            item.asEditable
          },
          acceptLanguage.map(value => value)
        )
    def serviceActionAssociations
        : List[zio.aws.servicecatalog.model.ServiceActionAssociation.ReadOnly]
    def acceptLanguage: Option[AcceptLanguage]
    def getServiceActionAssociations: ZIO[Any, Nothing, List[
      zio.aws.servicecatalog.model.ServiceActionAssociation.ReadOnly
    ]] = ZIO.succeed(serviceActionAssociations)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest
  ) extends zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest.ReadOnly {
    override val serviceActionAssociations
        : List[zio.aws.servicecatalog.model.ServiceActionAssociation.ReadOnly] =
      impl
        .serviceActionAssociations()
        .asScala
        .map { item =>
          zio.aws.servicecatalog.model.ServiceActionAssociation.wrap(item)
        }
        .toList
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest
  ): zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
