package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class AcceptPortfolioShareRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    portfolioId: Id,
    portfolioShareType: Option[
      zio.aws.servicecatalog.model.PortfolioShareType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest = {
    import AcceptPortfolioShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .optionallyWith(portfolioShareType.map(value => value.unwrap))(
        _.portfolioShareType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.AcceptPortfolioShareRequest.ReadOnly =
    zio.aws.servicecatalog.model.AcceptPortfolioShareRequest
      .wrap(buildAwsValue())
}
object AcceptPortfolioShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.AcceptPortfolioShareRequest =
      zio.aws.servicecatalog.model.AcceptPortfolioShareRequest(
        acceptLanguage.map(value => value),
        portfolioId,
        portfolioShareType.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def portfolioId: Id
    def portfolioShareType
        : Option[zio.aws.servicecatalog.model.PortfolioShareType]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getPortfolioShareType
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.PortfolioShareType] =
      AwsError.unwrapOptionField("portfolioShareType", portfolioShareType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest
  ) extends zio.aws.servicecatalog.model.AcceptPortfolioShareRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val portfolioShareType
        : Option[zio.aws.servicecatalog.model.PortfolioShareType] = scala
      .Option(impl.portfolioShareType())
      .map(value => zio.aws.servicecatalog.model.PortfolioShareType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest
  ): zio.aws.servicecatalog.model.AcceptPortfolioShareRequest.ReadOnly =
    new Wrapper(impl)
}
