package zio.aws.serverlessapplicationrepository.model
import zio.aws.serverlessapplicationrepository.model.primitives.{
  __string,
  MaxItems
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListApplicationsRequest(
    maxItems: Optional[MaxItems] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest = {
    import ListApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest
      .builder()
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest
      .wrap(buildAwsValue())
}
object ListApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest =
      zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest(
        maxItems.map(value => value),
        nextToken.map(value => value)
      )
    def maxItems: Optional[MaxItems]
    def nextToken: Optional[__string]
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest
  ) extends zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest.ReadOnly {
    override val maxItems: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.MaxItems(value)
      )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest
  ): zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
