package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UnshareApplicationRequest(
    applicationId: __string,
    organizationId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest = {
    import UnshareApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .organizationId(organizationId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest
      .wrap(buildAwsValue())
}
object UnshareApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest =
      zio.aws.serverlessapplicationrepository.model
        .UnshareApplicationRequest(applicationId, organizationId)
    def applicationId: __string
    def organizationId: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getOrganizationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(organizationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest
  ) extends zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val organizationId: __string = impl.organizationId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest
  ): zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
