package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListApplicationsResponse(
    applications: Optional[
      Iterable[zio.aws.serverlessapplicationrepository.model.ApplicationSummary]
    ] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse
      .builder()
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse
      .wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse =
      zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse(
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applications: Optional[List[
      zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly
    ]]
    def nextToken: Optional[__string]
    def getApplications: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("applications", applications)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse
  ) extends zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.ReadOnly {
    override val applications: Optional[List[
      zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.applications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.ApplicationSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse
  ): zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
