package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateCloudFormationChangeSetResponse(
    applicationId: Optional[__string] = Optional.Absent,
    changeSetId: Optional[__string] = Optional.Absent,
    semanticVersion: Optional[__string] = Optional.Absent,
    stackId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse = {
    import CreateCloudFormationChangeSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse
      .builder()
      .optionallyWith(applicationId.map(value => value: java.lang.String))(
        _.applicationId
      )
      .optionallyWith(changeSetId.map(value => value: java.lang.String))(
        _.changeSetId
      )
      .optionallyWith(semanticVersion.map(value => value: java.lang.String))(
        _.semanticVersion
      )
      .optionallyWith(stackId.map(value => value: java.lang.String))(_.stackId)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse
      .wrap(buildAwsValue())
}
object CreateCloudFormationChangeSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse =
      zio.aws.serverlessapplicationrepository.model
        .CreateCloudFormationChangeSetResponse(
          applicationId.map(value => value),
          changeSetId.map(value => value),
          semanticVersion.map(value => value),
          stackId.map(value => value)
        )
    def applicationId: Optional[__string]
    def changeSetId: Optional[__string]
    def semanticVersion: Optional[__string]
    def stackId: Optional[__string]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getChangeSetId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("changeSetId", changeSetId)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
    def getStackId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("stackId", stackId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse
  ) extends zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.ReadOnly {
    override val applicationId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => value: __string)
    override val changeSetId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.changeSetId())
      .map(value => value: __string)
    override val semanticVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.semanticVersion())
      .map(value => value: __string)
    override val stackId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.stackId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse
  ): zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.ReadOnly =
    new Wrapper(impl)
}
