package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.serverlessapplicationrepository.model.primitives.{
  __boolean,
  __string
}
import scala.jdk.CollectionConverters.*
final case class CreateApplicationVersionResponse(
    applicationId: Optional[__string] = Optional.Absent,
    creationTime: Optional[__string] = Optional.Absent,
    parameterDefinitions: Optional[Iterable[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition
    ]] = Optional.Absent,
    requiredCapabilities: Optional[
      Iterable[zio.aws.serverlessapplicationrepository.model.Capability]
    ] = Optional.Absent,
    resourcesSupported: Optional[__boolean] = Optional.Absent,
    semanticVersion: Optional[__string] = Optional.Absent,
    sourceCodeArchiveUrl: Optional[__string] = Optional.Absent,
    sourceCodeUrl: Optional[__string] = Optional.Absent,
    templateUrl: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse = {
    import CreateApplicationVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse
      .builder()
      .optionallyWith(applicationId.map(value => value: java.lang.String))(
        _.applicationId
      )
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .optionallyWith(
        parameterDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterDefinitions)
      .optionallyWith(
        requiredCapabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.requiredCapabilitiesWithStrings)
      .optionallyWith(
        resourcesSupported.map(value => value: java.lang.Boolean)
      )(_.resourcesSupported)
      .optionallyWith(semanticVersion.map(value => value: java.lang.String))(
        _.semanticVersion
      )
      .optionallyWith(
        sourceCodeArchiveUrl.map(value => value: java.lang.String)
      )(_.sourceCodeArchiveUrl)
      .optionallyWith(sourceCodeUrl.map(value => value: java.lang.String))(
        _.sourceCodeUrl
      )
      .optionallyWith(templateUrl.map(value => value: java.lang.String))(
        _.templateUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse
      .wrap(buildAwsValue())
}
object CreateApplicationVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse =
      zio.aws.serverlessapplicationrepository.model
        .CreateApplicationVersionResponse(
          applicationId.map(value => value),
          creationTime.map(value => value),
          parameterDefinitions.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          requiredCapabilities.map(value => value),
          resourcesSupported.map(value => value),
          semanticVersion.map(value => value),
          sourceCodeArchiveUrl.map(value => value),
          sourceCodeUrl.map(value => value),
          templateUrl.map(value => value)
        )
    def applicationId: Optional[__string]
    def creationTime: Optional[__string]
    def parameterDefinitions: Optional[List[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly
    ]]
    def requiredCapabilities: Optional[
      List[zio.aws.serverlessapplicationrepository.model.Capability]
    ]
    def resourcesSupported: Optional[__boolean]
    def semanticVersion: Optional[__string]
    def sourceCodeArchiveUrl: Optional[__string]
    def sourceCodeUrl: Optional[__string]
    def templateUrl: Optional[__string]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getCreationTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getParameterDefinitions: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("parameterDefinitions", parameterDefinitions)
    def getRequiredCapabilities: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.Capability
    ]] =
      AwsError.unwrapOptionField("requiredCapabilities", requiredCapabilities)
    def getResourcesSupported: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("resourcesSupported", resourcesSupported)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
    def getSourceCodeArchiveUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeArchiveUrl", sourceCodeArchiveUrl)
    def getSourceCodeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeUrl", sourceCodeUrl)
    def getTemplateUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateUrl", templateUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse
  ) extends zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.ReadOnly {
    override val applicationId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => value: __string)
    override val creationTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __string)
    override val parameterDefinitions: Optional[List[
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.ParameterDefinition
            .wrap(item)
        }.toList
      )
    override val requiredCapabilities: Optional[
      List[zio.aws.serverlessapplicationrepository.model.Capability]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requiredCapabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.Capability.wrap(item)
        }.toList
      )
    override val resourcesSupported: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.resourcesSupported())
      .map(value => value: __boolean)
    override val semanticVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.semanticVersion())
      .map(value => value: __string)
    override val sourceCodeArchiveUrl: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceCodeArchiveUrl())
        .map(value => value: __string)
    override val sourceCodeUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCodeUrl())
      .map(value => value: __string)
    override val templateUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateUrl())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse
  ): zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.ReadOnly =
    new Wrapper(impl)
}
