package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetApplicationPolicyResponse(
    statements: Optional[Iterable[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyResponse = {
    import GetApplicationPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyResponse
      .builder()
      .optionallyWith(
        statements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statements)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyResponse
      .wrap(buildAwsValue())
}
object GetApplicationPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyResponse =
      zio.aws.serverlessapplicationrepository.model
        .GetApplicationPolicyResponse(
          statements.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def statements: Optional[List[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly
    ]]
    def getStatements: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly
    ]] = AwsError.unwrapOptionField("statements", statements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyResponse
  ) extends zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyResponse.ReadOnly {
    override val statements: Optional[List[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.statements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyResponse
  ): zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
