package zio.aws.serverlessapplicationrepository.model
import zio.aws.serverlessapplicationrepository.model.primitives.{
  __boolean,
  __integer,
  __string
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ParameterDefinition(
    allowedPattern: Optional[__string] = Optional.Absent,
    allowedValues: Optional[Iterable[__string]] = Optional.Absent,
    constraintDescription: Optional[__string] = Optional.Absent,
    defaultValue: Optional[__string] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    maxLength: Optional[__integer] = Optional.Absent,
    maxValue: Optional[__integer] = Optional.Absent,
    minLength: Optional[__integer] = Optional.Absent,
    minValue: Optional[__integer] = Optional.Absent,
    name: __string,
    noEcho: Optional[__boolean] = Optional.Absent,
    referencedByResources: Iterable[__string],
    `type`: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition = {
    import ParameterDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition
      .builder()
      .optionallyWith(allowedPattern.map(value => value: java.lang.String))(
        _.allowedPattern
      )
      .optionallyWith(
        allowedValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowedValues)
      .optionallyWith(
        constraintDescription.map(value => value: java.lang.String)
      )(_.constraintDescription)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(maxLength.map(value => value: Integer))(_.maxLength)
      .optionallyWith(maxValue.map(value => value: Integer))(_.maxValue)
      .optionallyWith(minLength.map(value => value: Integer))(_.minLength)
      .optionallyWith(minValue.map(value => value: Integer))(_.minValue)
      .name(name: java.lang.String)
      .optionallyWith(noEcho.map(value => value: java.lang.Boolean))(_.noEcho)
      .referencedByResources(referencedByResources.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ParameterDefinition
      .wrap(buildAwsValue())
}
object ParameterDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ParameterDefinition =
      zio.aws.serverlessapplicationrepository.model.ParameterDefinition(
        allowedPattern.map(value => value),
        allowedValues.map(value => value),
        constraintDescription.map(value => value),
        defaultValue.map(value => value),
        description.map(value => value),
        maxLength.map(value => value),
        maxValue.map(value => value),
        minLength.map(value => value),
        minValue.map(value => value),
        name,
        noEcho.map(value => value),
        referencedByResources,
        `type`.map(value => value)
      )
    def allowedPattern: Optional[__string]
    def allowedValues: Optional[List[__string]]
    def constraintDescription: Optional[__string]
    def defaultValue: Optional[__string]
    def description: Optional[__string]
    def maxLength: Optional[__integer]
    def maxValue: Optional[__integer]
    def minLength: Optional[__integer]
    def minValue: Optional[__integer]
    def name: __string
    def noEcho: Optional[__boolean]
    def referencedByResources: List[__string]
    def `type`: Optional[__string]
    def getAllowedPattern: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("allowedPattern", allowedPattern)
    def getAllowedValues: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getConstraintDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("constraintDescription", constraintDescription)
    def getDefaultValue: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getMaxLength: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxLength", maxLength)
    def getMaxValue: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxValue", maxValue)
    def getMinLength: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minLength", minLength)
    def getMinValue: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getNoEcho: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("noEcho", noEcho)
    def getReferencedByResources: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(referencedByResources)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition
  ) extends zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly {
    override val allowedPattern: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedPattern())
      .map(value => value: __string)
    override val allowedValues: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedValues())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val constraintDescription: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraintDescription())
        .map(value => value: __string)
    override val defaultValue: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: __string)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val maxLength: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxLength())
      .map(value => value: __integer)
    override val maxValue: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxValue())
      .map(value => value: __integer)
    override val minLength: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minLength())
      .map(value => value: __integer)
    override val minValue: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minValue())
      .map(value => value: __integer)
    override val name: __string = impl.name(): __string
    override val noEcho: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.noEcho())
      .map(value => value: __boolean)
    override val referencedByResources: List[__string] = impl
      .referencedByResources()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val `type`: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition
  ): zio.aws.serverlessapplicationrepository.model.ParameterDefinition.ReadOnly =
    new Wrapper(impl)
}
