package zio.aws.serverlessapplicationrepository
import zio.aws.serverlessapplicationrepository.model.UpdateApplicationResponse.ReadOnly
import software.amazon.awssdk.services.serverlessapplicationrepository.{
  ServerlessApplicationRepositoryAsyncClientBuilder,
  ServerlessApplicationRepositoryAsyncClient
}
import software.amazon.awssdk.services.serverlessapplicationrepository.model.{
  CreateApplicationVersionResponse,
  CreateCloudFormationChangeSetResponse,
  UpdateApplicationRequest,
  ListApplicationDependenciesResponse,
  VersionSummary,
  CreateCloudFormationTemplateResponse,
  PutApplicationPolicyRequest,
  DeleteApplicationRequest,
  CreateCloudFormationChangeSetRequest,
  CreateApplicationVersionRequest,
  ApplicationDependencySummary,
  UpdateApplicationResponse,
  CreateApplicationRequest,
  GetCloudFormationTemplateRequest,
  ListApplicationsResponse,
  ListApplicationDependenciesRequest,
  GetApplicationPolicyRequest,
  GetCloudFormationTemplateResponse,
  ListApplicationVersionsResponse,
  GetApplicationRequest,
  CreateApplicationResponse,
  UnshareApplicationResponse,
  PutApplicationPolicyResponse,
  ListApplicationsRequest,
  UnshareApplicationRequest,
  ListApplicationVersionsRequest,
  ApplicationSummary,
  GetApplicationResponse,
  DeleteApplicationResponse,
  CreateCloudFormationTemplateRequest,
  GetApplicationPolicyResponse
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait ServerlessApplicationRepository
    extends AspectSupport[ServerlessApplicationRepository] {
  val api: ServerlessApplicationRepositoryAsyncClient
  def getApplication(
      request: zio.aws.serverlessapplicationrepository.model.GetApplicationRequest
  ): IO[
    AwsError,
    zio.aws.serverlessapplicationrepository.model.GetApplicationResponse.ReadOnly
  ]
  def deleteApplication(
      request: zio.aws.serverlessapplicationrepository.model.DeleteApplicationRequest
  ): IO[AwsError, Unit]
  def getCloudFormationTemplate(
      request: zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateRequest
  ): IO[
    AwsError,
    zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse.ReadOnly
  ]
  def listApplicationDependencies(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary.ReadOnly
  ]
  def listApplicationDependenciesPaginated(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
  ): IO[
    AwsError,
    zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesResponse.ReadOnly
  ]
  def putApplicationPolicy(
      request: zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyRequest
  ): IO[
    AwsError,
    zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyResponse.ReadOnly
  ]
  def createApplicationVersion(
      request: zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest
  ): IO[
    AwsError,
    zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.ReadOnly
  ]
  def createApplication(
      request: zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest
  ): IO[
    AwsError,
    zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse.ReadOnly
  ]
  def createCloudFormationChangeSet(
      request: zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
  ): IO[
    AwsError,
    zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.ReadOnly
  ]
  def unshareApplication(
      request: zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest
  ): IO[AwsError, Unit]
  def listApplications(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly
  ]
  def listApplicationsPaginated(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest
  ): IO[
    AwsError,
    zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.ReadOnly
  ]
  def updateApplication(
      request: zio.aws.serverlessapplicationrepository.model.UpdateApplicationRequest
  ): IO[AwsError, ReadOnly]
  def listApplicationVersions(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly
  ]
  def listApplicationVersionsPaginated(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsRequest
  ): IO[
    AwsError,
    zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsResponse.ReadOnly
  ]
  def createCloudFormationTemplate(
      request: zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest
  ): IO[
    AwsError,
    zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse.ReadOnly
  ]
  def getApplicationPolicy(
      request: zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyRequest
  ): IO[
    AwsError,
    zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyResponse.ReadOnly
  ]
}
object ServerlessApplicationRepository {
  val live: ZLayer[
    AwsConfig,
    java.lang.Throwable,
    ServerlessApplicationRepository
  ] = customized(identity)
  def customized(
      customization: ServerlessApplicationRepositoryAsyncClientBuilder => ServerlessApplicationRepositoryAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ServerlessApplicationRepository] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ServerlessApplicationRepositoryAsyncClientBuilder => ServerlessApplicationRepositoryAsyncClientBuilder
  ): ZIO[
    AwsConfig with Scope,
    java.lang.Throwable,
    ServerlessApplicationRepository
  ] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ServerlessApplicationRepositoryAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      ServerlessApplicationRepositoryAsyncClient,
      ServerlessApplicationRepositoryAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      ServerlessApplicationRepositoryAsyncClient,
      ServerlessApplicationRepositoryAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ServerlessApplicationRepositoryImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ServerlessApplicationRepositoryImpl[R](
      override val api: ServerlessApplicationRepositoryAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ServerlessApplicationRepository
      with AwsServiceBase[R] {
    override val serviceName: String = "ServerlessApplicationRepository"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ServerlessApplicationRepositoryImpl[R1] =
      new ServerlessApplicationRepositoryImpl(api, newAspect, r)
    def getApplication(
        request: zio.aws.serverlessapplicationrepository.model.GetApplicationRequest
    ): IO[
      AwsError,
      zio.aws.serverlessapplicationrepository.model.GetApplicationResponse.ReadOnly
    ] = asyncRequestResponse[GetApplicationRequest, GetApplicationResponse](
      "getApplication",
      api.getApplication
    )(request.buildAwsValue())
      .map(
        zio.aws.serverlessapplicationrepository.model.GetApplicationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteApplication(
        request: zio.aws.serverlessapplicationrepository.model.DeleteApplicationRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteApplicationRequest, DeleteApplicationResponse](
        "deleteApplication",
        api.deleteApplication
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getCloudFormationTemplate(
        request: zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateRequest
    ): IO[
      AwsError,
      zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCloudFormationTemplateRequest,
      GetCloudFormationTemplateResponse
    ]("getCloudFormationTemplate", api.getCloudFormationTemplate)(
      request.buildAwsValue()
    ).map(
      zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse.wrap
    ).provideEnvironment(r)
    def listApplicationDependencies(
        request: zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListApplicationDependenciesRequest,
      ListApplicationDependenciesResponse,
      ApplicationDependencySummary
    ](
      "listApplicationDependencies",
      api.listApplicationDependencies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dependencies().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listApplicationDependenciesPaginated(
        request: zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
    ): IO[
      AwsError,
      zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListApplicationDependenciesRequest,
      ListApplicationDependenciesResponse
    ]("listApplicationDependencies", api.listApplicationDependencies)(
      request.buildAwsValue()
    ).map(
      zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesResponse.wrap
    ).provideEnvironment(r)
    def putApplicationPolicy(
        request: zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyRequest
    ): IO[
      AwsError,
      zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      PutApplicationPolicyRequest,
      PutApplicationPolicyResponse
    ]("putApplicationPolicy", api.putApplicationPolicy)(request.buildAwsValue())
      .map(
        zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyResponse.wrap
      )
      .provideEnvironment(r)
    def createApplicationVersion(
        request: zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest
    ): IO[
      AwsError,
      zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateApplicationVersionRequest,
      CreateApplicationVersionResponse
    ]("createApplicationVersion", api.createApplicationVersion)(
      request.buildAwsValue()
    ).map(
      zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.wrap
    ).provideEnvironment(r)
    def createApplication(
        request: zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest
    ): IO[
      AwsError,
      zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateApplicationRequest,
      CreateApplicationResponse
    ]("createApplication", api.createApplication)(request.buildAwsValue())
      .map(
        zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse.wrap
      )
      .provideEnvironment(r)
    def createCloudFormationChangeSet(
        request: zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
    ): IO[
      AwsError,
      zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCloudFormationChangeSetRequest,
      CreateCloudFormationChangeSetResponse
    ]("createCloudFormationChangeSet", api.createCloudFormationChangeSet)(
      request.buildAwsValue()
    ).map(
      zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.wrap
    ).provideEnvironment(r)
    def unshareApplication(
        request: zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UnshareApplicationRequest,
      UnshareApplicationResponse
    ]("unshareApplication", api.unshareApplication)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listApplications(
        request: zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListApplicationsRequest,
      ListApplicationsResponse,
      ApplicationSummary
    ](
      "listApplications",
      api.listApplications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applications().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.serverlessapplicationrepository.model.ApplicationSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listApplicationsPaginated(
        request: zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest
    ): IO[
      AwsError,
      zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[ListApplicationsRequest, ListApplicationsResponse](
      "listApplications",
      api.listApplications
    )(request.buildAwsValue())
      .map(
        zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.wrap
      )
      .provideEnvironment(r)
    def updateApplication(
        request: zio.aws.serverlessapplicationrepository.model.UpdateApplicationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      UpdateApplicationRequest,
      UpdateApplicationResponse
    ]("updateApplication", api.updateApplication)(request.buildAwsValue())
      .map(
        zio.aws.serverlessapplicationrepository.model.UpdateApplicationResponse.wrap
      )
      .provideEnvironment(r)
    def listApplicationVersions(
        request: zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListApplicationVersionsRequest,
      ListApplicationVersionsResponse,
      VersionSummary
    ](
      "listApplicationVersions",
      api.listApplicationVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.versions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.serverlessapplicationrepository.model.VersionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listApplicationVersionsPaginated(
        request: zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsRequest
    ): IO[
      AwsError,
      zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListApplicationVersionsRequest,
      ListApplicationVersionsResponse
    ]("listApplicationVersions", api.listApplicationVersions)(
      request.buildAwsValue()
    ).map(
      zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsResponse.wrap
    ).provideEnvironment(r)
    def createCloudFormationTemplate(
        request: zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest
    ): IO[
      AwsError,
      zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCloudFormationTemplateRequest,
      CreateCloudFormationTemplateResponse
    ]("createCloudFormationTemplate", api.createCloudFormationTemplate)(
      request.buildAwsValue()
    ).map(
      zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse.wrap
    ).provideEnvironment(r)
    def getApplicationPolicy(
        request: zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyRequest
    ): IO[
      AwsError,
      zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetApplicationPolicyRequest,
      GetApplicationPolicyResponse
    ]("getApplicationPolicy", api.getApplicationPolicy)(request.buildAwsValue())
      .map(
        zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyResponse.wrap
      )
      .provideEnvironment(r)
  }
  def getApplication(
      request: zio.aws.serverlessapplicationrepository.model.GetApplicationRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.GetApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplication(request))
  def deleteApplication(
      request: zio.aws.serverlessapplicationrepository.model.DeleteApplicationRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteApplication(request))
  def getCloudFormationTemplate(
      request: zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCloudFormationTemplate(request))
  def listApplicationDependencies(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
  ): ZStream[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.ApplicationDependencySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplicationDependencies(request))
  def listApplicationDependenciesPaginated(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.ListApplicationDependenciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationDependenciesPaginated(request))
  def putApplicationPolicy(
      request: zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putApplicationPolicy(request))
  def createApplicationVersion(
      request: zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplicationVersion(request))
  def createApplication(
      request: zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def createCloudFormationChangeSet(
      request: zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCloudFormationChangeSet(request))
  def unshareApplication(
      request: zio.aws.serverlessapplicationrepository.model.UnshareApplicationRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.unshareApplication(request))
  def listApplications(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest
  ): ZStream[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplications(request))
  def listApplicationsPaginated(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.ListApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationsPaginated(request))
  def updateApplication(
      request: zio.aws.serverlessapplicationrepository.model.UpdateApplicationRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplication(request))
  def listApplicationVersions(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsRequest
  ): ZStream[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplicationVersions(request))
  def listApplicationVersionsPaginated(
      request: zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationVersionsPaginated(request))
  def createCloudFormationTemplate(
      request: zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCloudFormationTemplate(request))
  def getApplicationPolicy(
      request: zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyRequest
  ): ZIO[
    zio.aws.serverlessapplicationrepository.ServerlessApplicationRepository,
    AwsError,
    zio.aws.serverlessapplicationrepository.model.GetApplicationPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplicationPolicy(request))
}
