package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateApplicationVersionRequest(
    applicationId: __string,
    semanticVersion: __string,
    sourceCodeArchiveUrl: Optional[__string] = Optional.Absent,
    sourceCodeUrl: Optional[__string] = Optional.Absent,
    templateBody: Optional[__string] = Optional.Absent,
    templateUrl: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest = {
    import CreateApplicationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .semanticVersion(semanticVersion: java.lang.String)
      .optionallyWith(
        sourceCodeArchiveUrl.map(value => value: java.lang.String)
      )(_.sourceCodeArchiveUrl)
      .optionallyWith(sourceCodeUrl.map(value => value: java.lang.String))(
        _.sourceCodeUrl
      )
      .optionallyWith(templateBody.map(value => value: java.lang.String))(
        _.templateBody
      )
      .optionallyWith(templateUrl.map(value => value: java.lang.String))(
        _.templateUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest
      .wrap(buildAwsValue())
}
object CreateApplicationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest =
      zio.aws.serverlessapplicationrepository.model
        .CreateApplicationVersionRequest(
          applicationId,
          semanticVersion,
          sourceCodeArchiveUrl.map(value => value),
          sourceCodeUrl.map(value => value),
          templateBody.map(value => value),
          templateUrl.map(value => value)
        )
    def applicationId: __string
    def semanticVersion: __string
    def sourceCodeArchiveUrl: Optional[__string]
    def sourceCodeUrl: Optional[__string]
    def templateBody: Optional[__string]
    def templateUrl: Optional[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getSemanticVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(semanticVersion)
    def getSourceCodeArchiveUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeArchiveUrl", sourceCodeArchiveUrl)
    def getSourceCodeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeUrl", sourceCodeUrl)
    def getTemplateBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateUrl", templateUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest
  ) extends zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val semanticVersion: __string = impl.semanticVersion(): __string
    override val sourceCodeArchiveUrl: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceCodeArchiveUrl())
        .map(value => value: __string)
    override val sourceCodeUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCodeUrl())
      .map(value => value: __string)
    override val templateBody: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => value: __string)
    override val templateUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateUrl())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest
  ): zio.aws.serverlessapplicationrepository.model.CreateApplicationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
