package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class PutApplicationPolicyRequest(
    applicationId: __string,
    statements: Iterable[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest = {
    import PutApplicationPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .statements(statements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyRequest
      .wrap(buildAwsValue())
}
object PutApplicationPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyRequest =
      zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyRequest(
        applicationId,
        statements.map { item =>
          item.asEditable
        }
      )
    def applicationId: __string
    def statements: List[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly
    ]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getStatements: ZIO[Any, Nothing, List[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly
    ]] = ZIO.succeed(statements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest
  ) extends zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val statements: List[
      zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement.ReadOnly
    ] = impl
      .statements()
      .asScala
      .map { item =>
        zio.aws.serverlessapplicationrepository.model.ApplicationPolicyStatement
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest
  ): zio.aws.serverlessapplicationrepository.model.PutApplicationPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
