package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateCloudFormationTemplateResponse(
    applicationId: Option[__string] = None,
    creationTime: Option[__string] = None,
    expirationTime: Option[__string] = None,
    semanticVersion: Option[__string] = None,
    status: Option[zio.aws.serverlessapplicationrepository.model.Status] = None,
    templateId: Option[__string] = None,
    templateUrl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse = {
    import CreateCloudFormationTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse
      .builder()
      .optionallyWith(applicationId.map(value => value: java.lang.String))(
        _.applicationId
      )
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .optionallyWith(expirationTime.map(value => value: java.lang.String))(
        _.expirationTime
      )
      .optionallyWith(semanticVersion.map(value => value: java.lang.String))(
        _.semanticVersion
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(templateId.map(value => value: java.lang.String))(
        _.templateId
      )
      .optionallyWith(templateUrl.map(value => value: java.lang.String))(
        _.templateUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse
      .wrap(buildAwsValue())
}
object CreateCloudFormationTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse =
      zio.aws.serverlessapplicationrepository.model
        .CreateCloudFormationTemplateResponse(
          applicationId.map(value => value),
          creationTime.map(value => value),
          expirationTime.map(value => value),
          semanticVersion.map(value => value),
          status.map(value => value),
          templateId.map(value => value),
          templateUrl.map(value => value)
        )
    def applicationId: Option[__string]
    def creationTime: Option[__string]
    def expirationTime: Option[__string]
    def semanticVersion: Option[__string]
    def status: Option[zio.aws.serverlessapplicationrepository.model.Status]
    def templateId: Option[__string]
    def templateUrl: Option[__string]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getCreationTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getExpirationTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.serverlessapplicationrepository.model.Status
    ] = AwsError.unwrapOptionField("status", status)
    def getTemplateId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateId", templateId)
    def getTemplateUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateUrl", templateUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse
  ) extends zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse.ReadOnly {
    override val applicationId: Option[__string] =
      scala.Option(impl.applicationId()).map(value => value: __string)
    override val creationTime: Option[__string] =
      scala.Option(impl.creationTime()).map(value => value: __string)
    override val expirationTime: Option[__string] =
      scala.Option(impl.expirationTime()).map(value => value: __string)
    override val semanticVersion: Option[__string] =
      scala.Option(impl.semanticVersion()).map(value => value: __string)
    override val status
        : Option[zio.aws.serverlessapplicationrepository.model.Status] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.Status.wrap(value)
      )
    override val templateId: Option[__string] =
      scala.Option(impl.templateId()).map(value => value: __string)
    override val templateUrl: Option[__string] =
      scala.Option(impl.templateUrl()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse
  ): zio.aws.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
