package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListApplicationVersionsResponse(
    nextToken: Option[__string] = None,
    versions: Option[
      Iterable[zio.aws.serverlessapplicationrepository.model.VersionSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse = {
    import ListApplicationVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsResponse.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsResponse
      .wrap(buildAwsValue())
}
object ListApplicationVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsResponse =
      zio.aws.serverlessapplicationrepository.model
        .ListApplicationVersionsResponse(
          nextToken.map(value => value),
          versions.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def nextToken: Option[__string]
    def versions: Option[List[
      zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVersions: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("versions", versions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse
  ) extends zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsResponse.ReadOnly {
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val versions: Option[List[
      zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly
    ]] = scala
      .Option(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.VersionSummary
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse
  ): zio.aws.serverlessapplicationrepository.model.ListApplicationVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
