package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateApplicationRequest(
    author: __string,
    description: __string,
    homePageUrl: Option[__string] = None,
    labels: Option[Iterable[__string]] = None,
    licenseBody: Option[__string] = None,
    licenseUrl: Option[__string] = None,
    name: __string,
    readmeBody: Option[__string] = None,
    readmeUrl: Option[__string] = None,
    semanticVersion: Option[__string] = None,
    sourceCodeArchiveUrl: Option[__string] = None,
    sourceCodeUrl: Option[__string] = None,
    spdxLicenseId: Option[__string] = None,
    templateBody: Option[__string] = None,
    templateUrl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest
      .builder()
      .author(author: java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(homePageUrl.map(value => value: java.lang.String))(
        _.homePageUrl
      )
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(licenseBody.map(value => value: java.lang.String))(
        _.licenseBody
      )
      .optionallyWith(licenseUrl.map(value => value: java.lang.String))(
        _.licenseUrl
      )
      .name(name: java.lang.String)
      .optionallyWith(readmeBody.map(value => value: java.lang.String))(
        _.readmeBody
      )
      .optionallyWith(readmeUrl.map(value => value: java.lang.String))(
        _.readmeUrl
      )
      .optionallyWith(semanticVersion.map(value => value: java.lang.String))(
        _.semanticVersion
      )
      .optionallyWith(
        sourceCodeArchiveUrl.map(value => value: java.lang.String)
      )(_.sourceCodeArchiveUrl)
      .optionallyWith(sourceCodeUrl.map(value => value: java.lang.String))(
        _.sourceCodeUrl
      )
      .optionallyWith(spdxLicenseId.map(value => value: java.lang.String))(
        _.spdxLicenseId
      )
      .optionallyWith(templateBody.map(value => value: java.lang.String))(
        _.templateBody
      )
      .optionallyWith(templateUrl.map(value => value: java.lang.String))(
        _.templateUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest
      .wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest =
      zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest(
        author,
        description,
        homePageUrl.map(value => value),
        labels.map(value => value),
        licenseBody.map(value => value),
        licenseUrl.map(value => value),
        name,
        readmeBody.map(value => value),
        readmeUrl.map(value => value),
        semanticVersion.map(value => value),
        sourceCodeArchiveUrl.map(value => value),
        sourceCodeUrl.map(value => value),
        spdxLicenseId.map(value => value),
        templateBody.map(value => value),
        templateUrl.map(value => value)
      )
    def author: __string
    def description: __string
    def homePageUrl: Option[__string]
    def labels: Option[List[__string]]
    def licenseBody: Option[__string]
    def licenseUrl: Option[__string]
    def name: __string
    def readmeBody: Option[__string]
    def readmeUrl: Option[__string]
    def semanticVersion: Option[__string]
    def sourceCodeArchiveUrl: Option[__string]
    def sourceCodeUrl: Option[__string]
    def spdxLicenseId: Option[__string]
    def templateBody: Option[__string]
    def templateUrl: Option[__string]
    def getAuthor: ZIO[Any, Nothing, __string] = ZIO.succeed(author)
    def getDescription: ZIO[Any, Nothing, __string] = ZIO.succeed(description)
    def getHomePageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("homePageUrl", homePageUrl)
    def getLabels: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("labels", labels)
    def getLicenseBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("licenseBody", licenseBody)
    def getLicenseUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("licenseUrl", licenseUrl)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getReadmeBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("readmeBody", readmeBody)
    def getReadmeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("readmeUrl", readmeUrl)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
    def getSourceCodeArchiveUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeArchiveUrl", sourceCodeArchiveUrl)
    def getSourceCodeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeUrl", sourceCodeUrl)
    def getSpdxLicenseId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("spdxLicenseId", spdxLicenseId)
    def getTemplateBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateUrl", templateUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest
  ) extends zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest.ReadOnly {
    override val author: __string = impl.author(): __string
    override val description: __string = impl.description(): __string
    override val homePageUrl: Option[__string] =
      scala.Option(impl.homePageUrl()).map(value => value: __string)
    override val labels: Option[List[__string]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val licenseBody: Option[__string] =
      scala.Option(impl.licenseBody()).map(value => value: __string)
    override val licenseUrl: Option[__string] =
      scala.Option(impl.licenseUrl()).map(value => value: __string)
    override val name: __string = impl.name(): __string
    override val readmeBody: Option[__string] =
      scala.Option(impl.readmeBody()).map(value => value: __string)
    override val readmeUrl: Option[__string] =
      scala.Option(impl.readmeUrl()).map(value => value: __string)
    override val semanticVersion: Option[__string] =
      scala.Option(impl.semanticVersion()).map(value => value: __string)
    override val sourceCodeArchiveUrl: Option[__string] =
      scala.Option(impl.sourceCodeArchiveUrl()).map(value => value: __string)
    override val sourceCodeUrl: Option[__string] =
      scala.Option(impl.sourceCodeUrl()).map(value => value: __string)
    override val spdxLicenseId: Option[__string] =
      scala.Option(impl.spdxLicenseId()).map(value => value: __string)
    override val templateBody: Option[__string] =
      scala.Option(impl.templateBody()).map(value => value: __string)
    override val templateUrl: Option[__string] =
      scala.Option(impl.templateUrl()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest
  ): zio.aws.serverlessapplicationrepository.model.CreateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
