package zio.aws.serverlessapplicationrepository.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.{
  __string,
  MaxItems
}
import scala.jdk.CollectionConverters.*
final case class ListApplicationsRequest(
    maxItems: Option[MaxItems] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest = {
    import ListApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest
      .builder()
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest
      .wrap(buildAwsValue())
}
object ListApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest =
      zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest(
        maxItems.map(value => value),
        nextToken.map(value => value)
      )
    def maxItems: Option[MaxItems]
    def nextToken: Option[__string]
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest
  ) extends zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest.ReadOnly {
    override val maxItems: Option[MaxItems] = scala
      .Option(impl.maxItems())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.MaxItems(value)
      )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest
  ): zio.aws.serverlessapplicationrepository.model.ListApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
