package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ApplicationSummary(
    applicationId: __string,
    author: __string,
    creationTime: Option[__string] = None,
    description: __string,
    homePageUrl: Option[__string] = None,
    labels: Option[Iterable[__string]] = None,
    name: __string,
    spdxLicenseId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary
      .builder()
      .applicationId(applicationId: java.lang.String)
      .author(author: java.lang.String)
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .description(description: java.lang.String)
      .optionallyWith(homePageUrl.map(value => value: java.lang.String))(
        _.homePageUrl
      )
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .name(name: java.lang.String)
      .optionallyWith(spdxLicenseId.map(value => value: java.lang.String))(
        _.spdxLicenseId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.ApplicationSummary
      .wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.ApplicationSummary =
      zio.aws.serverlessapplicationrepository.model.ApplicationSummary(
        applicationId,
        author,
        creationTime.map(value => value),
        description,
        homePageUrl.map(value => value),
        labels.map(value => value),
        name,
        spdxLicenseId.map(value => value)
      )
    def applicationId: __string
    def author: __string
    def creationTime: Option[__string]
    def description: __string
    def homePageUrl: Option[__string]
    def labels: Option[List[__string]]
    def name: __string
    def spdxLicenseId: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getAuthor: ZIO[Any, Nothing, __string] = ZIO.succeed(author)
    def getCreationTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, Nothing, __string] = ZIO.succeed(description)
    def getHomePageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("homePageUrl", homePageUrl)
    def getLabels: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("labels", labels)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getSpdxLicenseId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("spdxLicenseId", spdxLicenseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary
  ) extends zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val author: __string = impl.author(): __string
    override val creationTime: Option[__string] =
      scala.Option(impl.creationTime()).map(value => value: __string)
    override val description: __string = impl.description(): __string
    override val homePageUrl: Option[__string] =
      scala.Option(impl.homePageUrl()).map(value => value: __string)
    override val labels: Option[List[__string]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val name: __string = impl.name(): __string
    override val spdxLicenseId: Option[__string] =
      scala.Option(impl.spdxLicenseId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary
  ): zio.aws.serverlessapplicationrepository.model.ApplicationSummary.ReadOnly =
    new Wrapper(impl)
}
