package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateCloudFormationChangeSetRequest(
    applicationId: __string,
    capabilities: Option[Iterable[__string]] = None,
    changeSetName: Option[__string] = None,
    clientToken: Option[__string] = None,
    description: Option[__string] = None,
    notificationArns: Option[Iterable[__string]] = None,
    parameterOverrides: Option[
      Iterable[zio.aws.serverlessapplicationrepository.model.ParameterValue]
    ] = None,
    resourceTypes: Option[Iterable[__string]] = None,
    rollbackConfiguration: Option[
      zio.aws.serverlessapplicationrepository.model.RollbackConfiguration
    ] = None,
    semanticVersion: Option[__string] = None,
    stackName: __string,
    tags: Option[Iterable[zio.aws.serverlessapplicationrepository.model.Tag]] =
      None,
    templateId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest = {
    import CreateCloudFormationChangeSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capabilities)
      .optionallyWith(
        changeSetName.map(value => __string.unwrap(value): java.lang.String)
      )(_.changeSetName)
      .optionallyWith(
        clientToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        notificationArns.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationArns)
      .optionallyWith(
        parameterOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterOverrides)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(
        rollbackConfiguration.map(value => value.buildAwsValue())
      )(_.rollbackConfiguration)
      .optionallyWith(
        semanticVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.semanticVersion)
      .stackName(__string.unwrap(stackName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        templateId.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateId)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
      .wrap(buildAwsValue())
}
object CreateCloudFormationChangeSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest =
      zio.aws.serverlessapplicationrepository.model
        .CreateCloudFormationChangeSetRequest(
          applicationId,
          capabilities.map(value => value),
          changeSetName.map(value => value),
          clientToken.map(value => value),
          description.map(value => value),
          notificationArns.map(value => value),
          parameterOverrides.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          resourceTypes.map(value => value),
          rollbackConfiguration.map(value => value.asEditable),
          semanticVersion.map(value => value),
          stackName,
          tags.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          templateId.map(value => value)
        )
    def applicationId: __string
    def capabilities: Option[List[__string]]
    def changeSetName: Option[__string]
    def clientToken: Option[__string]
    def description: Option[__string]
    def notificationArns: Option[List[__string]]
    def parameterOverrides: Option[List[
      zio.aws.serverlessapplicationrepository.model.ParameterValue.ReadOnly
    ]]
    def resourceTypes: Option[List[__string]]
    def rollbackConfiguration: Option[
      zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly
    ]
    def semanticVersion: Option[__string]
    def stackName: __string
    def tags: Option[
      List[zio.aws.serverlessapplicationrepository.model.Tag.ReadOnly]
    ]
    def templateId: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCapabilities: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getChangeSetName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("changeSetName", changeSetName)
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getNotificationArns: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("notificationArns", notificationArns)
    def getParameterOverrides: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.ParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterOverrides", parameterOverrides)
    def getResourceTypes: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("rollbackConfiguration", rollbackConfiguration)
    def getSemanticVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("semanticVersion", semanticVersion)
    def getStackName: ZIO[Any, Nothing, __string] = ZIO.succeed(stackName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.serverlessapplicationrepository.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getTemplateId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateId", templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
  ) extends zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.applicationId())
    override val capabilities: Option[List[__string]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.primitives
            .__string(item)
        }.toList
      )
    override val changeSetName: Option[__string] = scala
      .Option(impl.changeSetName())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val clientToken: Option[__string] = scala
      .Option(impl.clientToken())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val notificationArns: Option[List[__string]] = scala
      .Option(impl.notificationArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.primitives
            .__string(item)
        }.toList
      )
    override val parameterOverrides: Option[List[
      zio.aws.serverlessapplicationrepository.model.ParameterValue.ReadOnly
    ]] = scala
      .Option(impl.parameterOverrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.ParameterValue
            .wrap(item)
        }.toList
      )
    override val resourceTypes: Option[List[__string]] = scala
      .Option(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.primitives
            .__string(item)
        }.toList
      )
    override val rollbackConfiguration: Option[
      zio.aws.serverlessapplicationrepository.model.RollbackConfiguration.ReadOnly
    ] = scala
      .Option(impl.rollbackConfiguration())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.RollbackConfiguration
          .wrap(value)
      )
    override val semanticVersion: Option[__string] = scala
      .Option(impl.semanticVersion())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
    override val stackName: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.stackName())
    override val tags: Option[
      List[zio.aws.serverlessapplicationrepository.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.serverlessapplicationrepository.model.Tag.wrap(item)
        }.toList
      )
    override val templateId: Option[__string] = scala
      .Option(impl.templateId())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
  ): zio.aws.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest.ReadOnly =
    new Wrapper(impl)
}
