package zio.aws.serverlessapplicationrepository.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.serverlessapplicationrepository.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class VersionSummary(
    applicationId: __string,
    creationTime: __string,
    semanticVersion: __string,
    sourceCodeUrl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary = {
    import VersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .creationTime(__string.unwrap(creationTime): java.lang.String)
      .semanticVersion(__string.unwrap(semanticVersion): java.lang.String)
      .optionallyWith(
        sourceCodeUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.sourceCodeUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly =
    zio.aws.serverlessapplicationrepository.model.VersionSummary
      .wrap(buildAwsValue())
}
object VersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.serverlessapplicationrepository.model.VersionSummary =
      zio.aws.serverlessapplicationrepository.model.VersionSummary(
        applicationId,
        creationTime,
        semanticVersion,
        sourceCodeUrl.map(value => value)
      )
    def applicationId: __string
    def creationTime: __string
    def semanticVersion: __string
    def sourceCodeUrl: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCreationTime: ZIO[Any, Nothing, __string] = ZIO.succeed(creationTime)
    def getSemanticVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(semanticVersion)
    def getSourceCodeUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceCodeUrl", sourceCodeUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary
  ) extends zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly {
    override val applicationId: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.applicationId())
    override val creationTime: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.creationTime())
    override val semanticVersion: __string =
      zio.aws.serverlessapplicationrepository.model.primitives
        .__string(impl.semanticVersion())
    override val sourceCodeUrl: Option[__string] = scala
      .Option(impl.sourceCodeUrl())
      .map(value =>
        zio.aws.serverlessapplicationrepository.model.primitives.__string(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary
  ): zio.aws.serverlessapplicationrepository.model.VersionSummary.ReadOnly =
    new Wrapper(impl)
}
